/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.util;

import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.util.Literals;
import org.openrdf.model.vocabulary.XMLSchema;
import org.openrdf.query.algebra.Compare;
import org.openrdf.query.algebra.evaluation.ValueExprEvaluationException;

public class QueryEvaluationUtil {
    public static boolean getEffectiveBooleanValue(Value value) throws ValueExprEvaluationException {
        if (value instanceof Literal) {
            Literal literal = (Literal)value;
            String label = literal.getLabel();
            URI datatype = literal.getDatatype();
            if (datatype.equals((Object)XMLSchema.STRING)) {
                return label.length() > 0;
            }
            if (datatype.equals((Object)XMLSchema.BOOLEAN)) {
                return "true".equals(label) || "1".equals(label);
            }
            if (datatype.equals((Object)XMLSchema.DECIMAL)) {
                try {
                    String normDec = XMLDatatypeUtil.normalizeDecimal((String)label);
                    return !normDec.equals("0.0");
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            if (XMLDatatypeUtil.isIntegerDatatype((URI)datatype)) {
                try {
                    String normInt = XMLDatatypeUtil.normalize((String)label, (URI)datatype);
                    return !normInt.equals("0");
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
            if (XMLDatatypeUtil.isFloatingPointDatatype((URI)datatype)) {
                try {
                    String normFP = XMLDatatypeUtil.normalize((String)label, (URI)datatype);
                    return !normFP.equals("0.0E0") && !normFP.equals("NaN");
                }
                catch (IllegalArgumentException e) {
                    return false;
                }
            }
        }
        throw new ValueExprEvaluationException();
    }

    public static boolean compare(Value leftVal, Value rightVal, Compare.CompareOp operator) throws ValueExprEvaluationException {
        if (leftVal instanceof Literal && rightVal instanceof Literal) {
            return QueryEvaluationUtil.compareLiterals((Literal)leftVal, (Literal)rightVal, operator);
        }
        switch (operator) {
            case EQ: {
                return QueryEvaluationUtil.valuesEqual(leftVal, rightVal);
            }
            case NE: {
                return !QueryEvaluationUtil.valuesEqual(leftVal, rightVal);
            }
        }
        throw new ValueExprEvaluationException("Only literals with compatible, ordered datatypes can be compared using <, <=, > and >= operators");
    }

    private static boolean valuesEqual(Value leftVal, Value rightVal) {
        return leftVal != null && rightVal != null && leftVal.equals(rightVal);
    }

    public static boolean compareLiterals(Literal leftLit, Literal rightLit, Compare.CompareOp operator) throws ValueExprEvaluationException {
        URI leftDatatype = leftLit.getDatatype();
        URI rightDatatype = rightLit.getDatatype();
        boolean leftLangLit = Literals.isLanguageLiteral((Literal)leftLit);
        boolean rightLangLit = Literals.isLanguageLiteral((Literal)rightLit);
        URI commonDatatype = null;
        if (QueryEvaluationUtil.isSimpleLiteral(leftLit) && QueryEvaluationUtil.isSimpleLiteral(rightLit)) {
            commonDatatype = XMLSchema.STRING;
        }
        Integer compareResult = null;
        if (QueryEvaluationUtil.isSimpleLiteral(leftLit) && QueryEvaluationUtil.isSimpleLiteral(rightLit)) {
            compareResult = leftLit.getLabel().compareTo(rightLit.getLabel());
        } else if (!leftLangLit && !rightLangLit || commonDatatype != null) {
            if (commonDatatype == null) {
                if (leftDatatype.equals((Object)rightDatatype)) {
                    commonDatatype = leftDatatype;
                } else if (XMLDatatypeUtil.isNumericDatatype((URI)leftDatatype) && XMLDatatypeUtil.isNumericDatatype((URI)rightDatatype)) {
                    commonDatatype = leftDatatype.equals((Object)XMLSchema.DOUBLE) || rightDatatype.equals((Object)XMLSchema.DOUBLE) ? XMLSchema.DOUBLE : (leftDatatype.equals((Object)XMLSchema.FLOAT) || rightDatatype.equals((Object)XMLSchema.FLOAT) ? XMLSchema.FLOAT : (leftDatatype.equals((Object)XMLSchema.DECIMAL) || rightDatatype.equals((Object)XMLSchema.DECIMAL) ? XMLSchema.DECIMAL : XMLSchema.INTEGER));
                }
            }
            if (commonDatatype != null) {
                try {
                    if (commonDatatype.equals((Object)XMLSchema.DOUBLE)) {
                        compareResult = Double.compare(leftLit.doubleValue(), rightLit.doubleValue());
                    } else if (commonDatatype.equals((Object)XMLSchema.FLOAT)) {
                        compareResult = Float.compare(leftLit.floatValue(), rightLit.floatValue());
                    } else if (commonDatatype.equals((Object)XMLSchema.DECIMAL)) {
                        compareResult = leftLit.decimalValue().compareTo(rightLit.decimalValue());
                    } else if (XMLDatatypeUtil.isIntegerDatatype((URI)commonDatatype)) {
                        compareResult = leftLit.integerValue().compareTo(rightLit.integerValue());
                    } else if (commonDatatype.equals((Object)XMLSchema.BOOLEAN)) {
                        Boolean leftBool = leftLit.booleanValue();
                        Boolean rightBool = rightLit.booleanValue();
                        compareResult = leftBool.compareTo(rightBool);
                    } else if (XMLDatatypeUtil.isCalendarDatatype((URI)commonDatatype)) {
                        XMLGregorianCalendar right;
                        XMLGregorianCalendar left = leftLit.calendarValue();
                        compareResult = left.compare(right = rightLit.calendarValue());
                        if (compareResult == 2) {
                            throw new ValueExprEvaluationException("Indeterminate result for date/time comparison");
                        }
                    } else if (commonDatatype.equals((Object)XMLSchema.STRING)) {
                        compareResult = leftLit.getLabel().compareTo(rightLit.getLabel());
                    }
                }
                catch (IllegalArgumentException e) {
                    if (leftLit.equals((Object)rightLit)) {
                        switch (operator) {
                            case EQ: {
                                return true;
                            }
                            case NE: {
                                return false;
                            }
                        }
                    }
                    throw new ValueExprEvaluationException(e);
                }
            }
        }
        if (compareResult != null) {
            switch (operator) {
                case LT: {
                    return compareResult < 0;
                }
                case LE: {
                    return compareResult <= 0;
                }
                case EQ: {
                    return compareResult == 0;
                }
                case NE: {
                    return compareResult != 0;
                }
                case GE: {
                    return compareResult >= 0;
                }
                case GT: {
                    return compareResult > 0;
                }
            }
            throw new IllegalArgumentException("Unknown operator: " + operator);
        }
        boolean literalsEqual = leftLit.equals((Object)rightLit);
        if (!literalsEqual) {
            if (!leftLangLit && !rightLangLit && QueryEvaluationUtil.isSupportedDatatype(leftDatatype) && QueryEvaluationUtil.isSupportedDatatype(rightDatatype)) {
                if (!XMLDatatypeUtil.isValidValue((String)leftLit.getLabel(), (URI)leftDatatype)) {
                    throw new ValueExprEvaluationException("not a valid datatype value: " + leftLit);
                }
                if (!XMLDatatypeUtil.isValidValue((String)rightLit.getLabel(), (URI)rightDatatype)) {
                    throw new ValueExprEvaluationException("not a valid datatype value: " + rightLit);
                }
                boolean leftString = leftDatatype.equals((Object)XMLSchema.STRING);
                boolean rightString = rightDatatype.equals((Object)XMLSchema.STRING);
                boolean leftNumeric = XMLDatatypeUtil.isNumericDatatype((URI)leftDatatype);
                boolean rightNumeric = XMLDatatypeUtil.isNumericDatatype((URI)rightDatatype);
                boolean leftDate = XMLDatatypeUtil.isCalendarDatatype((URI)leftDatatype);
                boolean rightDate = XMLDatatypeUtil.isCalendarDatatype((URI)rightDatatype);
                if (leftString != rightString) {
                    throw new ValueExprEvaluationException("Unable to compare strings with other supported types");
                }
                if (leftNumeric != rightNumeric) {
                    throw new ValueExprEvaluationException("Unable to compare numeric types with other supported types");
                }
                if (leftDate != rightDate) {
                    throw new ValueExprEvaluationException("Unable to compare date types with other supported types");
                }
            } else if (!leftLangLit && !rightLangLit) {
                throw new ValueExprEvaluationException("Unable to compare literals with unsupported types");
            }
        }
        switch (operator) {
            case EQ: {
                return literalsEqual;
            }
            case NE: {
                return !literalsEqual;
            }
            case LT: 
            case LE: 
            case GE: 
            case GT: {
                throw new ValueExprEvaluationException("Only literals with compatible, ordered datatypes can be compared using <, <=, > and >= operators");
            }
        }
        throw new IllegalArgumentException("Unknown operator: " + operator);
    }

    public static boolean isPlainLiteral(Value v) {
        if (v instanceof Literal) {
            Literal l = (Literal)v;
            return l.getDatatype().equals((Object)XMLSchema.STRING);
        }
        return false;
    }

    public static boolean isSimpleLiteral(Value v) {
        if (v instanceof Literal) {
            return QueryEvaluationUtil.isSimpleLiteral((Literal)v);
        }
        return false;
    }

    public static boolean isSimpleLiteral(Literal l) {
        return !Literals.isLanguageLiteral((Literal)l) && l.getDatatype().equals((Object)XMLSchema.STRING);
    }

    public static boolean isStringLiteral(Value v) {
        if (v instanceof Literal) {
            return QueryEvaluationUtil.isStringLiteral((Literal)v);
        }
        return false;
    }

    public static boolean compatibleArguments(Literal arg1, Literal arg2) {
        boolean arg1Language = Literals.isLanguageLiteral((Literal)arg1);
        boolean arg2Language = Literals.isLanguageLiteral((Literal)arg2);
        boolean arg1Simple = QueryEvaluationUtil.isSimpleLiteral(arg1);
        boolean arg2Simple = QueryEvaluationUtil.isSimpleLiteral(arg2);
        boolean compatible = arg1Simple && arg2Simple || arg1Language && arg2Language && arg1.getLanguage().equals(arg2.getLanguage()) || arg1Language && arg2Simple;
        return compatible;
    }

    public static boolean isStringLiteral(Literal l) {
        URI datatype = l.getDatatype();
        return Literals.isLanguageLiteral((Literal)l) || datatype.equals((Object)XMLSchema.STRING);
    }

    private static boolean isSupportedDatatype(URI datatype) {
        return XMLSchema.STRING.equals((Object)datatype) || XMLDatatypeUtil.isNumericDatatype((URI)datatype) || XMLDatatypeUtil.isCalendarDatatype((URI)datatype);
    }
}

