/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.iterator;

import info.aduna.iteration.CloseableIteration;
import info.aduna.iteration.LookAheadIteration;
import java.util.Iterator;
import java.util.List;
import org.openrdf.query.BindingSet;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.QueryBindingSet;

public class CrossProductIteration
extends LookAheadIteration<BindingSet, QueryEvaluationException> {
    protected final List<BindingSet> inputBindings;
    protected final CloseableIteration<BindingSet, QueryEvaluationException> resultIteration;
    protected Iterator<BindingSet> inputBindingsIterator = null;
    protected BindingSet currentInputBinding = null;

    public CrossProductIteration(CloseableIteration<BindingSet, QueryEvaluationException> resultIteration, List<BindingSet> inputBindings) {
        this.resultIteration = resultIteration;
        this.inputBindings = inputBindings;
    }

    protected BindingSet getNextElement() throws QueryEvaluationException {
        if (this.currentInputBinding == null) {
            this.inputBindingsIterator = this.inputBindings.iterator();
            if (this.resultIteration.hasNext()) {
                this.currentInputBinding = (BindingSet)this.resultIteration.next();
            } else {
                return null;
            }
        }
        if (this.inputBindingsIterator.hasNext()) {
            BindingSet next = this.inputBindingsIterator.next();
            QueryBindingSet res = new QueryBindingSet(next.size() + this.currentInputBinding.size());
            res.addAll(next);
            res.addAll(this.currentInputBinding);
            if (!this.inputBindingsIterator.hasNext()) {
                this.currentInputBinding = null;
            }
            return res;
        }
        return null;
    }
}

