/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.impl;

import java.util.Collection;
import org.openrdf.query.algebra.ArbitraryLengthPath;
import org.openrdf.query.algebra.BinaryTupleOperator;
import org.openrdf.query.algebra.BindingSetAssignment;
import org.openrdf.query.algebra.EmptySet;
import org.openrdf.query.algebra.Join;
import org.openrdf.query.algebra.LeftJoin;
import org.openrdf.query.algebra.QueryModelNode;
import org.openrdf.query.algebra.QueryModelVisitor;
import org.openrdf.query.algebra.Service;
import org.openrdf.query.algebra.SingletonSet;
import org.openrdf.query.algebra.StatementPattern;
import org.openrdf.query.algebra.TupleExpr;
import org.openrdf.query.algebra.UnaryTupleOperator;
import org.openrdf.query.algebra.Var;
import org.openrdf.query.algebra.ZeroLengthPath;
import org.openrdf.query.algebra.evaluation.impl.ExternalSet;
import org.openrdf.query.algebra.helpers.QueryModelVisitorBase;

public class EvaluationStatistics {
    protected CardinalityCalculator cc;

    public synchronized double getCardinality(TupleExpr expr) {
        if (this.cc == null) {
            this.cc = this.createCardinalityCalculator();
        }
        expr.visit((QueryModelVisitor)this.cc);
        return this.cc.getCardinality();
    }

    protected CardinalityCalculator createCardinalityCalculator() {
        return new CardinalityCalculator();
    }

    private static class ServiceNodeAnalyzer
    extends QueryModelVisitorBase<RuntimeException> {
        private int count = 0;

        private ServiceNodeAnalyzer() {
        }

        public int getStatementCount() {
            return this.count;
        }

        public void meet(StatementPattern node) throws RuntimeException {
            ++this.count;
        }
    }

    protected static class CardinalityCalculator
    extends QueryModelVisitorBase<RuntimeException> {
        private static double VAR_CARDINALITY = 10.0;
        private static double UNBOUND_SERVICE_CARDINALITY = 100000.0;
        protected double cardinality;

        protected CardinalityCalculator() {
        }

        public double getCardinality() {
            return this.cardinality;
        }

        public void meet(EmptySet node) {
            this.cardinality = 0.0;
        }

        public void meet(SingletonSet node) {
            this.cardinality = 1.0;
        }

        public void meet(BindingSetAssignment node) {
            this.cardinality = 1.0;
        }

        public void meet(ZeroLengthPath node) {
            Var subjVar = node.getSubjectVar();
            Var objVar = node.getObjectVar();
            this.cardinality = subjVar != null && subjVar.hasValue() || objVar != null && objVar.hasValue() ? 1.0 : this.getSubjectCardinality(subjVar) * this.getObjectCardinality(objVar) * this.getContextCardinality(node.getContextVar());
        }

        public void meet(ArbitraryLengthPath node) {
            this.cardinality = this.getSubjectCardinality(node.getSubjectVar()) * this.getObjectCardinality(node.getObjectVar()) * this.getContextCardinality(node.getContextVar());
        }

        public void meet(Service node) {
            if (!node.getServiceRef().hasValue()) {
                this.cardinality = UNBOUND_SERVICE_CARDINALITY;
            } else {
                ServiceNodeAnalyzer serviceAnalyzer = new ServiceNodeAnalyzer();
                node.visitChildren((QueryModelVisitor)serviceAnalyzer);
                int count = serviceAnalyzer.getStatementCount();
                this.cardinality = count == 1 && node.getServiceVars().size() > 1 ? (double)(100 + node.getServiceVars().size()) : 1.0 + (double)node.getServiceVars().size() * 0.1;
            }
        }

        public void meet(StatementPattern sp) {
            this.cardinality = this.getCardinality(sp);
        }

        protected double getCardinality(StatementPattern sp) {
            return this.getSubjectCardinality(sp) * this.getPredicateCardinality(sp) * this.getObjectCardinality(sp) * this.getContextCardinality(sp);
        }

        protected double getSubjectCardinality(StatementPattern sp) {
            return this.getSubjectCardinality(sp.getSubjectVar());
        }

        protected double getSubjectCardinality(Var var) {
            return this.getCardinality(VAR_CARDINALITY, var);
        }

        protected double getPredicateCardinality(StatementPattern sp) {
            return this.getPredicateCardinality(sp.getPredicateVar());
        }

        protected double getPredicateCardinality(Var var) {
            return this.getCardinality(VAR_CARDINALITY, var);
        }

        protected double getObjectCardinality(StatementPattern sp) {
            return this.getObjectCardinality(sp.getObjectVar());
        }

        protected double getObjectCardinality(Var var) {
            return this.getCardinality(VAR_CARDINALITY, var);
        }

        protected double getContextCardinality(StatementPattern sp) {
            return this.getContextCardinality(sp.getContextVar());
        }

        protected double getContextCardinality(Var var) {
            return this.getCardinality(VAR_CARDINALITY, var);
        }

        protected double getCardinality(double varCardinality, Var var) {
            return var == null || var.hasValue() ? 1.0 : varCardinality;
        }

        protected double getCardinality(double varCardinality, Collection<Var> vars) {
            int constantVarCount = this.countConstantVars(vars);
            double unboundVarFactor = vars.size() - constantVarCount;
            return Math.pow(varCardinality, unboundVarFactor);
        }

        protected int countConstantVars(Iterable<Var> vars) {
            int constantVarCount = 0;
            for (Var var : vars) {
                if (!var.hasValue()) continue;
                ++constantVarCount;
            }
            return constantVarCount;
        }

        public void meet(Join node) {
            node.getLeftArg().visit((QueryModelVisitor)this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit((QueryModelVisitor)this);
            this.cardinality *= leftArgCost;
        }

        public void meet(LeftJoin node) {
            node.getLeftArg().visit((QueryModelVisitor)this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit((QueryModelVisitor)this);
            this.cardinality *= leftArgCost;
        }

        protected void meetBinaryTupleOperator(BinaryTupleOperator node) {
            node.getLeftArg().visit((QueryModelVisitor)this);
            double leftArgCost = this.cardinality;
            node.getRightArg().visit((QueryModelVisitor)this);
            this.cardinality += leftArgCost;
        }

        protected void meetUnaryTupleOperator(UnaryTupleOperator node) {
            node.getArg().visit((QueryModelVisitor)this);
        }

        protected void meetNode(QueryModelNode node) {
            if (!(node instanceof ExternalSet)) {
                throw new IllegalArgumentException("Unhandled node type: " + node.getClass());
            }
            this.meetExternalSet((ExternalSet)node);
        }

        protected void meetExternalSet(ExternalSet node) {
            this.cardinality = node.cardinality();
        }
    }
}

