/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.query.algebra.evaluation.federation;

import org.apache.http.client.HttpClient;
import org.openrdf.http.client.HttpClientDependent;
import org.openrdf.http.client.SesameClient;
import org.openrdf.http.client.SesameClientDependent;
import org.openrdf.http.client.SesameClientImpl;
import org.openrdf.query.QueryEvaluationException;
import org.openrdf.query.algebra.evaluation.federation.FederatedService;
import org.openrdf.query.algebra.evaluation.federation.FederatedServiceResolver;
import org.openrdf.query.algebra.evaluation.federation.FederatedServiceResolverBase;
import org.openrdf.query.algebra.evaluation.federation.SPARQLFederatedService;

public class FederatedServiceResolverImpl
extends FederatedServiceResolverBase
implements FederatedServiceResolver,
HttpClientDependent,
SesameClientDependent {
    private SesameClient client;
    private SesameClientImpl dependentClient;

    public synchronized SesameClient getSesameClient() {
        if (this.client == null) {
            this.dependentClient = new SesameClientImpl();
            this.client = this.dependentClient;
        }
        return this.client;
    }

    public synchronized void setSesameClient(SesameClient client) {
        this.client = client;
    }

    public HttpClient getHttpClient() {
        return this.getSesameClient().getHttpClient();
    }

    public void setHttpClient(HttpClient httpClient) {
        if (this.dependentClient == null) {
            this.dependentClient = new SesameClientImpl();
            this.client = this.dependentClient;
        }
        this.dependentClient.setHttpClient(httpClient);
    }

    @Override
    protected FederatedService createService(String serviceUrl) throws QueryEvaluationException {
        return new SPARQLFederatedService(serviceUrl, this.getSesameClient());
    }

    @Override
    public void shutDown() {
        super.shutDown();
        if (this.dependentClient != null) {
            this.dependentClient.shutDown();
            this.dependentClient = null;
        }
    }
}

