/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import org.openrdf.model.IRI;
import org.openrdf.model.impl.SimpleLiteral;
import org.openrdf.model.vocabulary.XMLSchema;

public class NumericLiteral
extends SimpleLiteral {
    private static final long serialVersionUID = 3004497457768807919L;
    private final Number number;

    protected NumericLiteral(Number number, IRI datatype) {
        super(number.toString(), datatype);
        this.number = number;
    }

    protected NumericLiteral(byte number) {
        this(number, XMLSchema.BYTE);
    }

    protected NumericLiteral(short number) {
        this(number, XMLSchema.SHORT);
    }

    protected NumericLiteral(int number) {
        this(number, XMLSchema.INT);
    }

    protected NumericLiteral(long n) {
        this(n, XMLSchema.LONG);
    }

    protected NumericLiteral(float n) {
        this(Float.valueOf(n), XMLSchema.FLOAT);
    }

    protected NumericLiteral(double n) {
        this(n, XMLSchema.DOUBLE);
    }

    @Override
    public byte byteValue() {
        return this.number.byteValue();
    }

    @Override
    public short shortValue() {
        return this.number.shortValue();
    }

    @Override
    public int intValue() {
        return this.number.intValue();
    }

    @Override
    public long longValue() {
        return this.number.longValue();
    }

    @Override
    public float floatValue() {
        return this.number.floatValue();
    }

    @Override
    public double doubleValue() {
        return this.number.doubleValue();
    }
}

