/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model;

import java.io.Serializable;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.openrdf.model.BNode;
import org.openrdf.model.Graph;
import org.openrdf.model.IRI;
import org.openrdf.model.Literal;
import org.openrdf.model.Namespace;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.impl.SimpleNamespace;
import org.openrdf.model.util.ModelException;

public interface Model
extends Graph,
Set<Statement>,
Serializable {
    public Model unmodifiable();

    public Set<Namespace> getNamespaces();

    default public Optional<Namespace> getNamespace(String prefix) {
        return this.getNamespaces().stream().filter(t -> t.getPrefix().equals(prefix)).findAny();
    }

    default public Namespace setNamespace(String prefix, String name) {
        Optional<Namespace> result = this.getNamespace(prefix);
        if (!result.isPresent() || !result.get().getName().equals(name)) {
            result = Optional.of(new SimpleNamespace(prefix, name));
            this.setNamespace(result.get());
        }
        return result.get();
    }

    public void setNamespace(Namespace var1);

    public Optional<Namespace> removeNamespace(String var1);

    public boolean contains(Resource var1, IRI var2, Value var3, Resource ... var4);

    @Deprecated
    default public boolean contains(Resource subj, URI pred, Value obj, Resource ... contexts) {
        return this.contains(subj, (IRI)pred, obj, contexts);
    }

    @Override
    public boolean add(Resource var1, IRI var2, Value var3, Resource ... var4);

    @Deprecated
    default public boolean add(Resource subj, URI pred, Value obj, Resource ... contexts) {
        return this.add(subj, (IRI)pred, obj, contexts);
    }

    public boolean clear(Resource ... var1);

    public boolean remove(Resource var1, IRI var2, Value var3, Resource ... var4);

    @Deprecated
    default public boolean remove(Resource subj, URI pred, Value obj, Resource ... contexts) {
        return this.remove(subj, (IRI)pred, obj, contexts);
    }

    public Model filter(Resource var1, IRI var2, Value var3, Resource ... var4);

    @Deprecated
    default public Model filter(Resource subj, URI pred, Value obj, Resource ... contexts) {
        return this.filter(subj, (IRI)pred, obj, contexts);
    }

    public Set<Resource> subjects();

    @Deprecated
    default public Optional<Resource> subjectResource() throws ModelException {
        Set result = this.stream().map(st -> st.getSubject()).distinct().limit(2L).collect(Collectors.toSet());
        if (result.isEmpty()) {
            return Optional.empty();
        }
        if (result.size() > 1) {
            throw new ModelException("Did not find a unique subject resource");
        }
        return Optional.of(result.iterator().next());
    }

    @Deprecated
    default public Optional<IRI> subjectIRI() throws ModelException {
        Optional<Resource> subjectResource = this.subjectResource();
        if (subjectResource.isPresent()) {
            if (subjectResource.get() instanceof IRI) {
                return Optional.of((IRI)subjectResource.get());
            }
            throw new ModelException("Did not find a unique subject URI");
        }
        return Optional.empty();
    }

    @Deprecated
    default public Optional<IRI> subjectURI() throws ModelException {
        return this.subjectIRI();
    }

    @Deprecated
    default public Optional<BNode> subjectBNode() throws ModelException {
        Optional<Resource> subjectResource = this.subjectResource();
        if (subjectResource.isPresent()) {
            if (subjectResource.get() instanceof BNode) {
                return Optional.of((BNode)subjectResource.get());
            }
            throw new ModelException("Did not find a unique subject URI");
        }
        return Optional.empty();
    }

    public Set<IRI> predicates();

    public Set<Value> objects();

    default public Set<Resource> contexts() {
        Set<Resource> subjects = this.stream().map(st -> st.getContext()).collect(Collectors.toSet());
        return subjects;
    }

    @Deprecated
    default public Optional<Value> objectValue() throws ModelException {
        Set result = this.stream().map(st -> st.getObject()).distinct().limit(2L).collect(Collectors.toSet());
        if (result.isEmpty()) {
            return Optional.empty();
        }
        if (result.size() > 1) {
            throw new ModelException("Did not find a unique object value");
        }
        return Optional.of(result.iterator().next());
    }

    @Deprecated
    default public Optional<Literal> objectLiteral() throws ModelException {
        Optional<Value> objectValue = this.objectValue();
        if (objectValue.isPresent()) {
            if (objectValue.get() instanceof Literal) {
                return Optional.of((Literal)objectValue.get());
            }
            throw new ModelException("Did not find a unique object literal");
        }
        return Optional.empty();
    }

    @Deprecated
    default public Optional<Resource> objectResource() throws ModelException {
        Optional<Value> objectValue = this.objectValue();
        if (objectValue.isPresent()) {
            if (objectValue.get() instanceof Resource) {
                return Optional.of((Resource)objectValue.get());
            }
            throw new ModelException("Did not find a unique object resource");
        }
        return Optional.empty();
    }

    @Deprecated
    default public Optional<IRI> objectIRI() throws ModelException {
        Optional<Value> objectValue = this.objectValue();
        if (objectValue.isPresent()) {
            if (objectValue.get() instanceof IRI) {
                return Optional.of((IRI)objectValue.get());
            }
            throw new ModelException("Did not find a unique object URI");
        }
        return Optional.empty();
    }

    @Deprecated
    default public Optional<IRI> objectURI() throws ModelException {
        return this.objectIRI();
    }

    @Deprecated
    default public Optional<String> objectString() throws ModelException {
        Optional<Value> objectValue = this.objectValue();
        if (objectValue.isPresent()) {
            return Optional.of(objectValue.get().stringValue());
        }
        return Optional.empty();
    }
}

