/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.model.impl;

import java.util.Date;
import java.util.GregorianCalendar;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.URI;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.datatypes.XMLDatatypeUtil;
import org.openrdf.model.vocabulary.XMLSchema;

public abstract class ValueFactoryBase
implements ValueFactory {
    private static long lastBNodePrefixUID = 0L;
    private static final DatatypeFactory datatypeFactory;
    private int nextBNodeID;
    private String bnodePrefix;

    private static synchronized long getNextBNodePrefixUid() {
        lastBNodePrefixUID = Math.max(System.currentTimeMillis(), lastBNodePrefixUID + 1L);
        return lastBNodePrefixUID;
    }

    public ValueFactoryBase() {
        this.initBNodeParams();
    }

    protected void initBNodeParams() {
        this.bnodePrefix = "node" + Long.toString(ValueFactoryBase.getNextBNodePrefixUid(), 32) + "x";
        this.nextBNodeID = 1;
    }

    @Override
    public synchronized BNode createBNode() {
        int id = this.nextBNodeID++;
        BNode result = this.createBNode(this.bnodePrefix + id);
        if (id == Integer.MAX_VALUE) {
            this.initBNodeParams();
        }
        return result;
    }

    @Override
    public Literal createLiteral(boolean b) {
        return this.createLiteral(Boolean.toString(b), XMLSchema.BOOLEAN);
    }

    @Override
    public Literal createLiteral(byte value) {
        return this.createIntegerLiteral(value, XMLSchema.BYTE);
    }

    @Override
    public Literal createLiteral(short value) {
        return this.createIntegerLiteral(value, XMLSchema.SHORT);
    }

    @Override
    public Literal createLiteral(int value) {
        return this.createIntegerLiteral(value, XMLSchema.INT);
    }

    @Override
    public Literal createLiteral(long value) {
        return this.createIntegerLiteral(value, XMLSchema.LONG);
    }

    protected Literal createIntegerLiteral(Number value, URI datatype) {
        return this.createNumericLiteral(value, datatype);
    }

    @Override
    public Literal createLiteral(float value) {
        return this.createFPLiteral(Float.valueOf(value), XMLSchema.FLOAT);
    }

    @Override
    public Literal createLiteral(double value) {
        return this.createFPLiteral(value, XMLSchema.DOUBLE);
    }

    protected Literal createFPLiteral(Number value, URI datatype) {
        return this.createNumericLiteral(value, datatype);
    }

    protected Literal createNumericLiteral(Number number, URI datatype) {
        return this.createLiteral(XMLDatatypeUtil.toString(number), datatype);
    }

    @Override
    public Literal createLiteral(XMLGregorianCalendar calendar) {
        return this.createLiteral(calendar.toXMLFormat(), XMLDatatypeUtil.qnameToURI(calendar.getXMLSchemaType()));
    }

    @Override
    public Literal createLiteral(Date date) {
        GregorianCalendar c = new GregorianCalendar();
        c.setTime(date);
        XMLGregorianCalendar xmlGregCalendar = datatypeFactory.newXMLGregorianCalendar(c);
        return this.createLiteral(xmlGregCalendar);
    }

    static {
        try {
            datatypeFactory = DatatypeFactory.newInstance();
        }
        catch (DatatypeConfigurationException e) {
            throw new Error("Could not instantiate javax.xml.datatype.DatatypeFactory", e);
        }
    }
}

