/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sailimpl.omm.security;

import java.util.ArrayList;
import java.util.Iterator;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.sesame.omm.SecurityServices;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.sail.ResourceIterator;
import org.openrdf.sesame.sail.ValueIterator;
import org.openrdf.sesame.sailimpl.omm.security.NullParameterException;

public class ResourceFilterIterator
implements ResourceIterator {
    SecurityServices service = null;
    ArrayList list = new ArrayList();
    Iterator iter = null;

    public ResourceFilterIterator(ResourceIterator ri, SecurityServices serv) throws NullParameterException, QueryEvaluationException {
        if (null == ri) {
            throw new NullParameterException("[ResourceIterator] should not be [null].");
        }
        if (null == serv) {
            throw new NullParameterException("[SecurityServices] should not be [null].");
        }
        this.service = serv;
        while (ri.hasNext()) {
            Resource res = ri.nextResource();
            if (!this.service.isResourceAccessible(res)) continue;
            this.list.add(res);
        }
        this.iter = this.list.iterator();
    }

    public ResourceFilterIterator(ValueIterator vi, SecurityServices serv) throws NullParameterException, QueryEvaluationException {
        if (null == vi) {
            throw new NullParameterException("[ValueIterator] should not be [null].");
        }
        if (null == serv) {
            throw new NullParameterException("[SecurityServices] should not be [null].");
        }
        this.service = serv;
        while (vi.hasNext()) {
            Value val = vi.next();
            if (val instanceof Resource) {
                Resource res = (Resource)val;
                if (!this.service.isResourceAccessible(res)) continue;
                this.list.add(res);
                continue;
            }
            this.list.add(val);
        }
        this.iter = this.list.iterator();
    }

    public ResourceFilterIterator() {
        this.iter = this.list.iterator();
    }

    public Resource nextResource() {
        return (Resource)this.iter.next();
    }

    public boolean hasNext() {
        return this.iter.hasNext();
    }

    public Value next() {
        return (Value)this.iter.next();
    }

    public void close() {
    }
}

