/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.sail.query;

import java.util.Collection;
import org.openrdf.model.Resource;
import org.openrdf.model.Statement;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.sail.RdfSource;
import org.openrdf.sesame.sail.StatementIterator;
import org.openrdf.sesame.sail.query.PathExpression;
import org.openrdf.sesame.sail.query.SailQueryException;
import org.openrdf.sesame.sail.query.Var;
import org.openrdf.sesame.sail.util.EmptyStatementIterator;

public class TriplePattern
implements PathExpression {
    private Var _subjectVar;
    private Var _predicateVar;
    private Var _objectVar;
    private StatementIterator _statementIter;
    private boolean _subjectVarLocked;
    private boolean _predicateVarLocked;
    private boolean _objectVarLocked;

    public TriplePattern(Var subjectVar, Var predicateVar, Var objectVar) {
        this._subjectVar = subjectVar;
        this._predicateVar = predicateVar;
        this._objectVar = objectVar;
    }

    public Var getSubjectVar() {
        return this._subjectVar;
    }

    public Var getPredicateVar() {
        return this._predicateVar;
    }

    public Var getObjectVar() {
        return this._objectVar;
    }

    public void initialize(RdfSource rdfSource) throws SailQueryException {
        this._subjectVarLocked = this._subjectVar.hasValue();
        this._predicateVarLocked = this._predicateVar.hasValue();
        this._objectVarLocked = this._objectVar.hasValue();
        try {
            Resource subjectValue = (Resource)this._subjectVar.getValue();
            URI predicateValue = (URI)this._predicateVar.getValue();
            Value objectValue = this._objectVar.getValue();
            this._statementIter = this._getStatementIterator(rdfSource, subjectValue, predicateValue, objectValue);
        }
        catch (ClassCastException e) {
            this._statementIter = new EmptyStatementIterator();
        }
    }

    protected StatementIterator _getStatementIterator(RdfSource rdfSource, Resource subj, URI pred, Value obj) throws SailQueryException {
        return rdfSource.getStatements(subj, pred, obj);
    }

    public boolean selectNext(RdfSource rdfSource) {
        while (this._statementIter.hasNext()) {
            Statement st = this._statementIter.next();
            if (!this._subjectVarLocked) {
                this._subjectVar.setValue((Value)st.getSubject());
            }
            if (!this._predicateVarLocked) {
                if (this._predicateVar == this._subjectVar) {
                    if (!st.getSubject().equals(st.getPredicate())) {
                        continue;
                    }
                } else {
                    this._predicateVar.setValue((Value)st.getPredicate());
                }
            }
            if (!this._objectVarLocked) {
                if (this._objectVar == this._subjectVar) {
                    if (!st.getSubject().equals(st.getObject())) {
                        continue;
                    }
                } else if (this._objectVar == this._predicateVar) {
                    if (!st.getPredicate().equals(st.getObject())) {
                        continue;
                    }
                } else {
                    this._objectVar.setValue(st.getObject());
                }
            }
            return true;
        }
        this._releaseLocks();
        return false;
    }

    public void clear() {
        if (this._statementIter != null) {
            this._statementIter.close();
            this._releaseLocks();
        }
    }

    private void _releaseLocks() {
        if (!this._subjectVarLocked) {
            this._subjectVar.setValue(null);
        }
        if (!this._predicateVarLocked) {
            this._predicateVar.setValue(null);
        }
        if (!this._objectVarLocked) {
            this._objectVar.setValue(null);
        }
    }

    public void getVariables(Collection variables) {
        variables.add(this._subjectVar);
        variables.add(this._predicateVar);
        variables.add(this._objectVar);
    }

    public String toString() {
        StringBuffer result = new StringBuffer(128);
        result.append("(");
        if (this._subjectVar.hasValue()) {
            result.append(this._subjectVar.getString());
        } else {
            result.append(this._subjectVar.toString());
        }
        result.append(",");
        if (this._predicateVar.hasValue()) {
            result.append(this._predicateVar.getString());
        } else {
            result.append(this._predicateVar.toString());
        }
        result.append(",");
        if (this._objectVar.hasValue()) {
            result.append(this._objectVar.getString());
        } else {
            result.append(this._objectVar.toString());
        }
        result.append(")");
        return result.toString();
    }
}

