/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.util.Iterator;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.rql.model.ClassQuery;
import org.openrdf.sesame.query.rql.model.ClassVar;
import org.openrdf.sesame.query.rql.model.Intersection;
import org.openrdf.sesame.query.rql.model.PropertyQuery;
import org.openrdf.sesame.query.rql.model.PropertyVar;
import org.openrdf.sesame.query.rql.model.Selector;
import org.openrdf.sesame.query.rql.model.iterators.StatementSubjectIterator;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ResourceIterator;

public class RangeSelector
implements Selector {
    protected ClassQuery _rangeQ;
    protected PropertyQuery _propQ;
    protected ResourceIterator _rangeIter;
    protected ResourceIterator _propIter;
    protected boolean _rangeQisVar;
    protected boolean _propQisVar;

    public RangeSelector(PropertyQuery propQ, ClassQuery rangeQ) {
        this._rangeQ = rangeQ;
        this._propQ = propQ;
    }

    public void initialize(RdfSchemaSource rss) throws QueryEvaluationException {
        this._rangeQisVar = this._rangeQ instanceof ClassVar && !((ClassVar)this._rangeQ).hasValue();
        this._propIter = this._propQ.getProperties(rss);
        boolean bl = this._propQisVar = this._propIter == null;
        if (this._propIter == null) {
            this._propIter = new StatementSubjectIterator(rss.getProperties());
        }
    }

    public boolean selectNext(RdfSchemaSource rss) throws QueryEvaluationException {
        if (this._rangeQisVar) {
            if ((this._rangeIter == null || !this._rangeIter.hasNext()) && this._propIter.hasNext()) {
                URI property = (URI)this._propIter.next();
                Intersection intersect = new Intersection(rss.getRange((Resource)property, null));
                Value propRange = intersect.minimize(rss);
                if (propRange instanceof Intersection) {
                    ((ClassVar)this._rangeQ).setValue(propRange);
                } else if (propRange instanceof Resource) {
                    this._rangeIter = new StatementSubjectIterator(rss.getSubClassOf(null, (Resource)propRange));
                    if (this._rangeIter.hasNext()) {
                        ((ClassVar)this._rangeQ).setValue(this._rangeIter.next());
                    }
                }
                if (this._propQisVar) {
                    ((PropertyVar)this._propQ).setValue((Value)property);
                }
                return true;
            }
            if (this._rangeIter != null && this._rangeIter.hasNext()) {
                Resource subClass = (Resource)this._rangeIter.next();
                ((ClassVar)this._rangeQ).setValue((Value)subClass);
                return true;
            }
            ((ClassVar)this._rangeQ).setValue(null);
            if (this._propQisVar) {
                ((PropertyVar)this._propQ).setValue(null);
            }
            return false;
        }
        boolean result = false;
        while (this._propIter.hasNext()) {
            URI property = (URI)this._propIter.next();
            if (this._propQisVar) {
                ((PropertyVar)this._propQ).setValue((Value)property);
            }
            Intersection intersect = new Intersection(rss.getRange((Resource)property, null));
            Value propRange = intersect.minimize(rss);
            this._rangeIter = this._rangeQ.getClasses(rss);
            while (this._rangeIter.hasNext()) {
                Value nextRange = this._rangeIter.next();
                if (nextRange.equals(propRange)) {
                    result = true;
                    break;
                }
                if (propRange instanceof Intersection) {
                    if (nextRange instanceof Intersection) {
                        result = ((Intersection)nextRange).lowerEqualThan((Intersection)propRange, rss);
                        if (!result) continue;
                        break;
                    }
                    if (!(nextRange instanceof Resource)) continue;
                    Iterator intersectIter = ((Intersection)propRange).getMembers().iterator();
                    Resource member = null;
                    boolean mismatch = false;
                    while (intersectIter.hasNext()) {
                        member = (Resource)intersectIter.next();
                        if (rss.isSubClassOf((Resource)nextRange, member)) continue;
                        mismatch = true;
                        break;
                    }
                    if (mismatch) continue;
                    result = true;
                    break;
                }
                if (nextRange instanceof Intersection) {
                    Intersection myIntersection = new Intersection();
                    myIntersection.add((Resource)propRange);
                    result = ((Intersection)nextRange).lowerEqualThan(myIntersection, rss);
                    if (!result) continue;
                    break;
                }
                if (!(nextRange instanceof Resource) || !(propRange instanceof Resource) || !rss.isSubClassOf((Resource)nextRange, (Resource)propRange)) continue;
                result = true;
                break;
            }
            this._rangeIter.close();
            if (!result) continue;
            if (!this._propQisVar) {
                this._propIter.close();
            }
            return true;
        }
        if (this._rangeQisVar) {
            ((ClassVar)this._rangeQ).setValue(null);
        }
        if (this._propQisVar) {
            ((PropertyVar)this._propQ).setValue(null);
        }
        return false;
    }

    public void clear() {
        if (this._propIter != null) {
            this._propIter.close();
            if (this._rangeIter != null) {
                this._rangeIter.close();
            }
            if (this._rangeQisVar) {
                ((ClassVar)this._rangeQ).setValue(null);
            }
            if (this._propQisVar) {
                ((PropertyVar)this._propQ).setValue(null);
            }
            this._propIter = null;
        }
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this._propQ.toString());
        result.append("{:");
        result.append(this._rangeQ.toString());
        result.append("}");
        return result.toString();
    }
}

