/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query.rql.model;

import java.io.IOException;
import java.util.HashSet;
import java.util.NoSuchElementException;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryEvaluationException;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.DataVar;
import org.openrdf.sesame.query.rql.model.Projection;
import org.openrdf.sesame.query.rql.model.Query;
import org.openrdf.sesame.query.rql.model.SetQuery;
import org.openrdf.sesame.query.rql.model.SfwQuery;
import org.openrdf.sesame.sail.RdfSchemaSource;
import org.openrdf.sesame.sail.ValueIterator;

public class Minus
implements SetQuery {
    protected SfwQuery _arg1;
    protected SfwQuery _arg2;
    protected HashSet resultSet;
    protected int _projectionSize;

    public Minus(SfwQuery query1, SfwQuery query2) {
        this._arg1 = query1;
        this._arg2 = query2;
        this.resultSet = new HashSet();
    }

    public void evaluate(RdfSchemaSource rss, TableQueryResultListener listener) throws QueryEvaluationException {
        int proj2Size;
        int proj1Size = this._arg1.getProjection().size();
        if (proj1Size != (proj2Size = this._arg2.getProjection().size())) {
            throw new QueryEvaluationException("projection sizes must be equal");
        }
        this._projectionSize = proj1Size;
        String[] columnHeaders = new String[this._projectionSize];
        for (int i = 0; i < this._projectionSize; ++i) {
            Query projectionQ = (Query)this._arg1.getProjection().get(i);
            if (projectionQ instanceof DataVar && ((DataVar)projectionQ).getName().equals("NULL")) {
                projectionQ = (Query)this._arg2.getProjection().get(i);
            }
            columnHeaders[i] = projectionQ.getQuery();
        }
        MinusIterator unionIter = new MinusIterator(rss, this._arg1, this._arg2);
        try {
            listener.startTableQueryResult(columnHeaders);
            while (unionIter.hasNext()) {
                listener.startTuple();
                Projection projection = unionIter.next();
                for (int i = 0; i < this._projectionSize; ++i) {
                    Value val = projection.get(i);
                    listener.tupleValue(val);
                }
                listener.endTuple();
            }
            listener.endTableQueryResult();
        }
        catch (IOException e) {
            unionIter.close();
            throw new QueryEvaluationException(e);
        }
    }

    public ValueIterator getResources(RdfSchemaSource rss) {
        return null;
    }

    public boolean returnsSet() {
        return true;
    }

    public SfwQuery getArg1() {
        return this._arg1;
    }

    public SfwQuery getArg2() {
        return this._arg2;
    }

    public String getQuery() {
        return this.toString();
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append("( ");
        result.append(this._arg1.getQuery());
        result.append(" )");
        result.append("\nunion\n");
        result.append("( ");
        result.append(this._arg2.getQuery());
        result.append(" )\n");
        return result.toString();
    }

    static class MinusIterator {
        protected boolean _hasNext;
        protected ValueIterator _arg1Iterator;
        protected ValueIterator _arg2Iterator;
        private Projection _nextValue;
        private HashSet _resultSet;
        private boolean _initialized;

        public MinusIterator(RdfSchemaSource rss, SfwQuery arg1, SfwQuery arg2) throws QueryEvaluationException {
            this._arg1Iterator = arg1.getResources(rss);
            this._arg2Iterator = arg2.getResources(rss);
            this._initialized = false;
            this._resultSet = new HashSet();
        }

        public boolean hasNext() throws QueryEvaluationException {
            if (!this._initialized) {
                this._nextValue = this._getNextValue();
                this._hasNext = this._nextValue != null;
            }
            return this._hasNext;
        }

        public Projection next() throws QueryEvaluationException {
            Projection result = null;
            if (this.hasNext()) {
                result = this._nextValue;
                this._nextValue = this._getNextValue();
                this._hasNext = this._nextValue != null;
                return result;
            }
            throw new NoSuchElementException();
        }

        public void close() {
            if (!this._initialized) {
                this._arg1Iterator.close();
            }
            this._arg2Iterator.close();
        }

        protected void finalize() {
            this.close();
        }

        private Projection _getNextValue() throws QueryEvaluationException {
            Projection projection = null;
            Projection result = null;
            if (!this._initialized) {
                while (this._arg2Iterator.hasNext()) {
                    projection = (Projection)this._arg2Iterator.next();
                    this._resultSet.add(projection);
                }
                this._arg2Iterator.close();
                this._initialized = true;
            }
            if (!this._resultSet.isEmpty()) {
                while (this._arg1Iterator.hasNext()) {
                    projection = (Projection)this._arg1Iterator.next();
                    if (this._resultSet.contains(projection)) continue;
                    result = projection;
                    break;
                }
            }
            return result;
        }
    }
}

