/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.openrdf.model.BNode;
import org.openrdf.model.Literal;
import org.openrdf.model.Resource;
import org.openrdf.model.URI;
import org.openrdf.model.Value;
import org.openrdf.model.ValueFactory;
import org.openrdf.model.impl.ValueFactoryImpl;
import org.openrdf.sesame.query.QueryErrorType;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.Intersection;
import org.openrdf.util.xml.SimpleSAXAdapter;
import org.openrdf.util.xml.SimpleSAXListener;
import org.openrdf.util.xml.SimpleSAXParser;
import org.xml.sax.SAXException;
import org.xml.sax.XMLReader;

public class XmlQueryResultReader {
    private SimpleSAXParser _simpleSAXParser;
    private ValueFactory _valueFactory;

    public XmlQueryResultReader(XMLReader xmlReader) {
        this(xmlReader, (ValueFactory)new ValueFactoryImpl());
    }

    public XmlQueryResultReader(XMLReader xmlReader, ValueFactory valueFactory) {
        this._simpleSAXParser = new SimpleSAXParser(xmlReader);
        this._valueFactory = valueFactory;
    }

    public synchronized void read(InputStream in, TableQueryResultListener listener) throws SAXException, IOException {
        this._simpleSAXParser.setListener((SimpleSAXListener)new XmlQueryResultParser(listener));
        this._simpleSAXParser.parse(in);
    }

    class XmlQueryResultParser
    extends SimpleSAXAdapter {
        private TableQueryResultListener _listener;
        private boolean _queryResultStarted;
        private boolean _parsingIntersection = false;
        private List _members = new ArrayList();
        private List _columnNames = new ArrayList();

        public XmlQueryResultParser(TableQueryResultListener listener) {
            this._listener = listener;
        }

        public void startTag(String tagName, Map atts, String text) throws SAXException {
            try {
                if (tagName.equals("columnName")) {
                    this._columnNames.add(text);
                } else if (tagName.equals("tuple")) {
                    if (!this._queryResultStarted) {
                        this._reportQueryResultStart();
                    }
                    this._listener.startTuple();
                } else if (tagName.equals("uri")) {
                    URI uri = XmlQueryResultReader.this._valueFactory.createURI(text);
                    if (this._parsingIntersection) {
                        this._members.add(uri);
                    } else {
                        this._listener.tupleValue((Value)uri);
                    }
                } else if (tagName.equals("bNode")) {
                    BNode bNode = XmlQueryResultReader.this._valueFactory.createBNode(text);
                    if (this._parsingIntersection) {
                        this._members.add(bNode);
                    } else {
                        this._listener.tupleValue((Value)bNode);
                    }
                } else if (tagName.equals("literal")) {
                    String xmlLang = (String)atts.get("xml:lang");
                    String datatype = (String)atts.get("datatype");
                    Literal literal = null;
                    if (datatype != null) {
                        URI dtURI = XmlQueryResultReader.this._valueFactory.createURI(datatype);
                        literal = XmlQueryResultReader.this._valueFactory.createLiteral(text, dtURI);
                    } else {
                        literal = xmlLang != null ? XmlQueryResultReader.this._valueFactory.createLiteral(text, xmlLang) : XmlQueryResultReader.this._valueFactory.createLiteral(text);
                    }
                    this._listener.tupleValue((Value)literal);
                } else if (tagName.equals("null")) {
                    this._listener.tupleValue(null);
                } else if (tagName.equals("intersection")) {
                    this._parsingIntersection = true;
                } else if (tagName.equals("error")) {
                    if (!this._queryResultStarted) {
                        this._reportQueryResultStart();
                    }
                    String type = (String)atts.get("type");
                    QueryErrorType errType = QueryErrorType.forValue(type);
                    this._listener.error(errType, text);
                }
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        public void endTag(String tagName) throws SAXException {
            try {
                if (tagName.equals("tableQueryResult")) {
                    if (!this._queryResultStarted) {
                        this._reportQueryResultStart();
                    }
                    this._listener.endTableQueryResult();
                } else if (tagName.equals("tuple")) {
                    this._listener.endTuple();
                } else if (tagName.equals("intersection")) {
                    Intersection intersection = new Intersection();
                    for (int i = 0; i < this._members.size(); ++i) {
                        intersection.add((Resource)this._members.get(i));
                    }
                    this._parsingIntersection = false;
                    this._members.clear();
                    this._listener.tupleValue((Value)intersection);
                }
            }
            catch (IOException e) {
                throw new SAXException(e);
            }
        }

        private void _reportQueryResultStart() throws IOException {
            if (this._columnNames.isEmpty()) {
                this._listener.startTableQueryResult();
            } else {
                String[] columns = new String[this._columnNames.size()];
                for (int i = 0; i < this._columnNames.size(); ++i) {
                    columns[i] = (String)this._columnNames.get(i);
                }
                this._listener.startTableQueryResult(columns);
            }
            this._queryResultStarted = true;
        }
    }
}

