/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.query;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.Iterator;
import org.openrdf.model.Resource;
import org.openrdf.model.Value;
import org.openrdf.sesame.query.QueryErrorType;
import org.openrdf.sesame.query.TableQueryResultListener;
import org.openrdf.sesame.query.rql.model.Intersection;
import org.openrdf.sesame.server.http.RdfExplorerUtil;
import org.openrdf.util.xml.XmlUtil;

public class HtmlTableWriter
implements TableQueryResultListener {
    protected Writer _out;
    protected String _repository;
    protected String _resultId;
    protected String _styleSheetUrl;
    protected int _nrOfResults;
    protected int _nrOfColumns;
    protected long _startTime;
    protected boolean _tupleOpen;
    protected boolean _tableOpen;

    public HtmlTableWriter(OutputStream out, String repository, String styleSheetUrl) throws IOException {
        this(out, repository, styleSheetUrl, "query_result");
    }

    public HtmlTableWriter(OutputStream out, String repository, String styleSheetUrl, String resultId) throws IOException {
        this._out = new OutputStreamWriter(out, "UTF-8");
        this._repository = repository;
        this._resultId = resultId;
        this._styleSheetUrl = styleSheetUrl;
        this._tupleOpen = false;
        this._tableOpen = false;
        this._startTime = System.currentTimeMillis();
    }

    public void startTableQueryResult() throws IOException {
        this._nrOfResults = 0;
        this._out.write("<html>\n");
        this._out.write("<head>\n");
        if (this._styleSheetUrl != null) {
            this._out.write("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + this._styleSheetUrl + "\">\n");
        }
        this._out.write("<meta http-equiv=\"Content-Type\" content=\"text/html; charset=utf-8\">");
        this._out.write("<title>Query Results</title>\n");
        this._out.write("</head>\n");
        this._out.write("<body bgcolor=\"white\">\n");
        this._out.write("<table>\n");
        this._out.write("<tr><th class=\"nobg\"");
        if (this._nrOfColumns > 0) {
            this._out.write(" colspan=\"" + this._nrOfColumns + "\"");
        }
        this._out.write(">Query results:</th></tr>\n");
        this._tableOpen = true;
    }

    public void startTableQueryResult(String[] columnHeaders) throws IOException {
        this._nrOfColumns = columnHeaders.length;
        this.startTableQueryResult();
        this._out.write("  <tr>\n");
        for (int i = 0; i < this._nrOfColumns; ++i) {
            this._out.write("    <th>");
            this._out.write(XmlUtil.escapeCharacterData((String)columnHeaders[i]));
            this._out.write("</th>\n");
        }
        this._out.write("  </tr>\n");
    }

    public void endTableQueryResult() throws IOException {
        long evalTime = System.currentTimeMillis() - this._startTime;
        if (this._tupleOpen) {
            this.endTuple();
        }
        if (this._tableOpen) {
            this._out.write("<tr><td class=\"nobg\"");
            if (this._nrOfColumns > 0) {
                this._out.write(" colspan=\"" + this._nrOfColumns + "\"");
            }
            this._out.write(">");
            this._out.write(this._nrOfResults + " results found in " + evalTime + " ms.</td></tr>\n");
            this.endTable();
        } else {
            this._out.write("<p>" + this._nrOfResults + " results found in " + evalTime + " ms.</p>\n");
        }
        this._out.write("</body>\n");
        this._out.write("</html>\n");
        this._out.flush();
        this._out.close();
    }

    public void startTuple() throws IOException {
        ++this._nrOfResults;
        this._out.write("  <tr>\n");
        this._tupleOpen = true;
    }

    public void endTuple() throws IOException {
        this._out.write("  </tr>\n");
        this._tupleOpen = false;
    }

    public void tupleValue(Value value) throws IOException {
        this._out.write("      <td>");
        if (value == null) {
            this._out.write("NULL");
        } else if (value instanceof Intersection) {
            Intersection intersect = (Intersection)value;
            Iterator iter = intersect.getMembers().iterator();
            if (iter.hasNext()) {
                this._out.write("{&nbsp;\n");
                while (iter.hasNext()) {
                    this._writeValueLink((Value)((Resource)iter.next()));
                    if (!iter.hasNext()) continue;
                    this._out.write(",<br>&nbsp;&nbsp;\n");
                }
                this._out.write("&nbsp;}\n");
            } else {
                this._out.write("{}\n");
            }
        } else {
            this._writeValueLink(value);
        }
        this._out.write("</td>\n");
    }

    private void _writeValueLink(Value value) throws IOException {
        this._out.write("<a target=\"rdfexplore\" href=\"");
        this._out.write("../explorer/show.jsp?");
        this._out.write(RdfExplorerUtil.getQueryString(this._repository, value, false));
        this._out.write("\">");
        this._out.write(XmlUtil.escapeCharacterData((String)RdfExplorerUtil.getDisplayString(value)));
        this._out.write("</a>");
    }

    public void error(QueryErrorType errType, String msg) throws IOException {
        if (!this._tableOpen) {
            this.startTableQueryResult();
        } else if (this._tupleOpen) {
            this.endTuple();
        }
        this._out.write("<tr><td");
        if (this._nrOfColumns > 0) {
            this._out.write(" colspan=" + this._nrOfColumns + ">");
        } else {
            this._out.write(">");
        }
        this._out.write("<font color=\"red\">");
        if (errType == QueryErrorType.MALFORMED_QUERY_ERROR) {
            this._out.write("Malformed query error: ");
        } else if (errType == QueryErrorType.QUERY_EVALUATION_ERROR) {
            this._out.write("Query evaluation error: ");
        } else {
            this._out.write("Error: ");
        }
        this._out.write(XmlUtil.escapeCharacterData((String)msg));
        this._out.write("</font></td></tr>\n");
    }

    protected void endTable() throws IOException {
        this._out.write("</table>\n");
        this._tableOpen = false;
    }
}

