/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.awt.GridBagLayout;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.net.URL;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import org.openrdf.sesame.config.SystemConfig;
import org.openrdf.sesame.config.SystemConfigListener;
import org.openrdf.sesame.config.ui.IntTextField;
import org.openrdf.sesame.config.ui.util.GridBagUtil;
import org.openrdf.sesame.config.ui.util.Util;

public class ServerTab
extends JPanel
implements SystemConfigListener,
ItemListener,
FocusListener {
    protected SystemConfig _config;
    protected JTextField _adminPassword;
    protected JTextField _logDir;
    protected JComboBox _logLevel;
    protected JTextField _tmpDir;
    protected JCheckBox _rmiEnabled;
    protected JLabel _rmiFactoryClassLabel;
    protected JTextField _rmiFactoryClass;
    protected JLabel _rmiPortLabel;
    protected IntTextField _rmiPort;

    public ServerTab(SystemConfig config) {
        this._config = config;
        this._config.addListener(this);
        this.setLayout(new GridBagLayout());
        this.setBorder(BorderFactory.createEmptyBorder(8, 8, 8, 8));
        URL url = this.getClass().getResource("icons/server.png");
        JLabel icon = new JLabel(new ImageIcon(url));
        GridBagUtil.constrain(this, icon, 0, 0, 1, 1, 0, 10, 0.0, 0.0, 0, 0, 4, 4);
        JTextArea explanation = Util.createReadOnlyTextArea("Use the fields below to change the server settings.", this.getBackground());
        GridBagUtil.constrain(this, explanation, 1, 0, 2, 1, 0, 17, 0.0, 0.0, 0, 4, 4, 0);
        GridBagUtil.constrain(this, new JLabel("Admin password:"), 0, 1, 2, 1, 0, 17, 0.0, 0.0, 4, 0, 0, 0);
        this._adminPassword = new JTextField();
        this._adminPassword.addFocusListener(this);
        GridBagUtil.constrain(this, this._adminPassword, 2, 1, 1, 1, 2, 17, 1.0, 0.0, 4, 4, 0, 0);
        GridBagUtil.constrain(this, new JLabel("Log directory:"), 0, 2, 2, 1, 0, 17, 0.0, 0.0, 20, 0, 0, 0);
        this._logDir = new JTextField();
        this._logDir.addFocusListener(this);
        GridBagUtil.constrain(this, this._logDir, 2, 2, 1, 1, 2, 17, 1.0, 0.0, 20, 4, 0, 0);
        GridBagUtil.constrain(this, new JLabel("Log level:"), 0, 3, 2, 1, 0, 17, 0.0, 0.0, 4, 0, 0, 0);
        this._logLevel = new JComboBox<String>(new String[]{"All", "Trace", "Status", "Warning", "Error", "None"});
        this._logLevel.addItemListener(this);
        GridBagUtil.constrain(this, this._logLevel, 2, 3, 1, 1, 0, 17, 0.0, 0.0, 4, 4, 0, 0);
        GridBagUtil.constrain(this, new JLabel("Tmp directory:"), 0, 4, 2, 1, 0, 17, 0.0, 0.0, 20, 0, 0, 0);
        this._tmpDir = new JTextField();
        this._tmpDir.addFocusListener(this);
        GridBagUtil.constrain(this, this._tmpDir, 2, 4, 1, 1, 2, 17, 1.0, 0.0, 20, 4, 0, 0);
        this._rmiEnabled = new JCheckBox("RMI service enabled");
        this._rmiEnabled.addItemListener(this);
        GridBagUtil.constrain(this, this._rmiEnabled, 0, 5, 3, 1, 2, 17, 1.0, 0.0, 20, 0, 0, 0);
        this._rmiFactoryClassLabel = new JLabel("RMI Factory class:");
        GridBagUtil.constrain(this, this._rmiFactoryClassLabel, 0, 6, 2, 1, 0, 17, 0.0, 0.0, 4, 0, 0, 0);
        this._rmiFactoryClass = new JTextField();
        this._rmiFactoryClass.addFocusListener(this);
        GridBagUtil.constrain(this, this._rmiFactoryClass, 2, 6, 1, 1, 2, 17, 1.0, 0.0, 4, 4, 0, 0);
        this._rmiPortLabel = new JLabel("RMI port:");
        GridBagUtil.constrain(this, this._rmiPortLabel, 0, 7, 2, 1, 0, 17, 0.0, 0.0, 4, 0, 0, 0);
        this._rmiPort = new IntTextField();
        this._rmiPort.addFocusListener(this);
        GridBagUtil.constrain(this, this._rmiPort, 2, 7, 1, 1, 2, 17, 1.0, 0.0, 4, 4, 0, 0);
        GridBagUtil.constrain(this, new JPanel(), 0, 8, 3, 1, 1, 10, 1.0, 1.0, 0, 0, 0, 0);
        this._updateTab();
    }

    protected void _updateTab() {
        if (this._config.getAdminPassword() == null) {
            this._adminPassword.setText("");
        } else {
            this._adminPassword.setText(this._config.getAdminPassword());
        }
        if (this._config.getLogDir() == null) {
            this._logDir.setText("");
        } else {
            this._logDir.setText(this._config.getLogDir());
        }
        this._logLevel.setSelectedIndex(5 - this._config.getLogLevel());
        if (this._config.getTmpDir() == null) {
            this._tmpDir.setText("");
        } else {
            this._tmpDir.setText(this._config.getTmpDir());
        }
        boolean rmiEnabled = this._config.isRMIEnabled();
        this._rmiEnabled.setSelected(rmiEnabled);
        this._rmiFactoryClass.setText(this._config.getRMIFactoryClass());
        this._rmiPort.setInt(this._config.getRMIPort());
        this._rmiFactoryClassLabel.setEnabled(rmiEnabled);
        this._rmiFactoryClass.setEnabled(rmiEnabled);
        this._rmiPortLabel.setEnabled(rmiEnabled);
        this._rmiPort.setEnabled(rmiEnabled);
    }

    public void configurationChanged() {
        this._updateTab();
    }

    public void focusGained(FocusEvent e) {
    }

    public void focusLost(FocusEvent e) {
        Object source = e.getSource();
        if (source == this._adminPassword) {
            String newAdminPassword = this._adminPassword.getText();
            if (!newAdminPassword.equals(this._config.getAdminPassword())) {
                this._config.setAdminPassword(newAdminPassword);
            }
        } else if (source == this._logDir) {
            String newLogDir = this._logDir.getText();
            if (newLogDir.trim().length() == 0) {
                if (this._config.getLogDir() != null) {
                    this._config.setLogDir(null);
                }
            } else if (!newLogDir.equals(this._config.getLogDir())) {
                this._config.setLogDir(newLogDir);
            }
        } else if (source == this._tmpDir) {
            String newTmpDir = this._tmpDir.getText();
            if (newTmpDir.trim().length() == 0) {
                if (this._config.getTmpDir() != null) {
                    this._config.setTmpDir(null);
                }
            } else if (!newTmpDir.equals(this._config.getTmpDir())) {
                this._config.setTmpDir(newTmpDir);
            }
        }
    }

    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if (source == this._logLevel) {
            int newLogLevel = 5 - this._logLevel.getSelectedIndex();
            if (newLogLevel != this._config.getLogLevel()) {
                this._config.setLogLevel(newLogLevel);
            }
        } else if (source == this._rmiEnabled) {
            this._config.setRMIEnabled(this._rmiEnabled.isSelected());
        }
    }
}

