/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.sesame.config.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import javax.swing.JLabel;

public class DialogSeparator
extends JLabel {
    public static final int OFFSET = 15;

    public DialogSeparator() {
    }

    public DialogSeparator(String text) {
        super(text);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.getParent().getWidth(), 20);
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void paintComponent(Graphics graphics) {
        super.paintComponent(graphics);
        graphics.setColor(this.getBackground());
        graphics.fillRect(0, 0, this.getWidth(), this.getHeight());
        Dimension dimension = this.getSize();
        int y = (dimension.height - 3) / 2;
        graphics.setColor(Color.white);
        graphics.drawLine(0, y, dimension.width - 1, y);
        graphics.drawLine(0, ++y, 1, y);
        graphics.setColor(Color.gray);
        graphics.drawLine(dimension.width - 1, y, dimension.width, y);
        graphics.drawLine(1, ++y, dimension.width - 1, y);
        String text = this.getText();
        if (text.length() == 0) {
            return;
        }
        graphics.setFont(this.getFont());
        FontMetrics metrics = graphics.getFontMetrics();
        y = (dimension.height + metrics.getAscent()) / 2;
        graphics.setColor(this.getBackground());
        graphics.fillRect(10, 0, 15 + metrics.stringWidth(text), dimension.height);
        graphics.setColor(this.getForeground());
        graphics.drawString(text, 15, y);
    }
}

