/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.vocabulary;

/**
 * Constants for RDF Schema primitives and for the RDF Schema namespace.
 **/
public class RDFS {

	/** http://www.w3.org/2000/01/rdf-schema# **/
	public static final String NAMESPACE =
		"http://www.w3.org/2000/01/rdf-schema#";

	/** http://www.w3.org/2000/01/rdf-schema#Resource **/
	public static final String RESOURCE = NAMESPACE + "Resource";

	/** http://www.w3.org/2000/01/rdf-schema#Literal **/
	public static final String LITERAL = NAMESPACE + "Literal";

	/** http://www.w3.org/2000/01/rdf-schema#Class **/
	public static final String CLASS = NAMESPACE + "Class";

	/** http://www.w3.org/2000/01/rdf-schema#subClassOf **/
	public static final String SUBCLASSOF = NAMESPACE + "subClassOf";

	/** http://www.w3.org/2000/01/rdf-schema#subPropertyOf **/
	public static final String SUBPROPERTYOF = NAMESPACE + "subPropertyOf";

	/** http://www.w3.org/2000/01/rdf-schema#domain **/
	public static final String DOMAIN = NAMESPACE + "domain";

	/** http://www.w3.org/2000/01/rdf-schema#range **/
	public static final String RANGE = NAMESPACE + "range";

	/** http://www.w3.org/2000/01/rdf-schema#comment **/
	public static final String COMMENT = NAMESPACE + "comment";

	/** http://www.w3.org/2000/01/rdf-schema#label **/
	public static final String LABEL = NAMESPACE + "label";

	/** http://www.w3.org/2000/01/rdf-schema#Datatype **/
	public static final String DATATYPE = NAMESPACE + "Datatype";

	/** http://www.w3.org/2000/01/rdf-schema#Container **/
	public static final String CONTAINER = NAMESPACE + "Container";

	/** http://www.w3.org/2000/01/rdf-schema#member **/
	public static final String MEMBER = NAMESPACE + "member";

	/** http://www.w3.org/2000/01/rdf-schema#isDefinedBy **/
	public static final String ISDEFINEDBY = NAMESPACE + "isDefinedBy";

	/** http://www.w3.org/2000/01/rdf-schema#seeAlso **/
	public static final String SEEALSO = NAMESPACE + "seeAlso";

	/** http://www.w3.org/2000/01/rdf-schema#ContainerMembershipProperty **/
	public static final String CONTAINERMEMBERSHIPPROPERTY =
			NAMESPACE + "ContainerMembershipProperty";
}
