/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.model.impl;

import java.io.Serializable;

import org.openrdf.model.BNode;
import org.openrdf.model.GraphException;
import org.openrdf.model.URI;
import org.openrdf.model.Value;

import org.openrdf.sesame.sail.StatementIterator;

/**
 * An implementation of the BNode interface.
 */
public class BNodeImpl implements BNode, Serializable {

/*-----------+
| Variables  |
+-----------*/

	private final String _id;

/*-------------+
| Constructors |
+-------------*/

	public BNodeImpl(String id) {
		_id = id;
	}

/*---------+
| Methods  |
+---------*/
	
	// Implements BNode.getID()
	public String getID() {
		return _id;
	}

	// Implements BNode.equals(Object)
	public boolean equals(Object o) {
		if (this == o) {
			return true;
		}

		if (o instanceof BNode) {
			BNode otherNode = (BNode)o;
			return this.getID().equals(otherNode.getID());
		}

		return false;
	}
	
	// Implements BNode.hashCode()
	public int hashCode() {
		return _id.hashCode();
	}

	/**
	 * Compares this BNode with the supplied object.
	 * 
	 * @throws ClassCastException if o is not of type BNode
	 * @see java.lang.Comparable
	 */
	public int compareTo(Object other) {
		if (this == other) {
			return 0;
		}

		if (other instanceof BNode) {
			return this.getID().compareTo( ((BNode)other).getID() );
		}
		else if (other instanceof URI) {
			// BNode > URI
			return 1;
		}
		else {
			// BNode < Literal
			return -1;
		}
	}

	/**
	 * Returns the BNode's string representation.
	 */
	public String toString() {
		return _id;
	}

	// Implements Resource.addProperty(URI, Value)
	public void addProperty(URI property, Value value)
		throws GraphException
	{
		throw new GraphException("no backing store associated");
	}

	// Implements Resource.getSubjectStatements()
	public StatementIterator getSubjectStatements()
		throws GraphException
	{
		throw new GraphException("no backing store associated");
	}

	// Implements Value.getObjectStatements()
	public StatementIterator getObjectStatements()
		throws GraphException
	{
		throw new GraphException("no backing store associated");
	}
}
