/*  Sesame - Storage and Querying architecture for RDF and RDF Schema
 *  Copyright (C) 2001-2006 Aduna
 *
 *  Contact: 
 *  	Aduna
 *  	Prinses Julianaplein 14 b
 *  	3817 CS Amersfoort
 *  	The Netherlands
 *  	tel. +33 (0)33 465 99 87
 *  	fax. +33 (0)33 465 99 87
 *
 *  	http://aduna-software.com/
 *  	http://www.openrdf.org/
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Lesser General Public
 *  License as published by the Free Software Foundation; either
 *  version 2.1 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Lesser General Public License for more details.
 *
 *  You should have received a copy of the GNU Lesser General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

package org.openrdf.model;

/**
 * A blank node (aka <em>bnode</em>, aka <em>anonymous node</em>). A blank node
 * has an identifier to be able to compare it to other blank nodes internally.
 * Please note that, conceptually, blank node equality can only be determined by
 * examining the statements that refer to them.
 **/
public interface BNode extends Resource {

	/**
	 * retrieves this bNode's identifier.
	 * @return a bnode identifier
	 */
	public String getID();
	
	/**
	 * Compares a blank node object to another object.
	 *
	 * @param o The object to compare this blank node to.
	 * @return <tt>true</tt> if the other object is an instance of {@link BNode}
	 * and their IDs are equal, <tt>false</tt> otherwise.
	 */
	public boolean equals(Object o);
	
	/**
	 * The hash code of a blank node is defined as the hash code of its
	 * identifier: <tt>id.hashCode()</tt>.
	 * 
	 * @return A hash code for the blank node.
	 */
	public int hashCode();
}
