/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.transportlayer.client;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.Closeable;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.net.Socket;
import javax.net.SocketFactory;
import org.openmuc.jdlms.settings.client.TcpSettings;
import org.openmuc.jdlms.transportlayer.client.TransportLayer;

public class TcpLayer
implements TransportLayer {
    private Socket socket;
    private DataOutputStream os;
    private DataInputStream is;
    private boolean closed;
    private final TcpSettings settings;

    public TcpLayer(TcpSettings settings) {
        this.settings = settings;
        this.closed = true;
    }

    @Override
    public void setTimeout(int timeout) throws IOException {
        this.socket.setSoTimeout(timeout);
    }

    @Override
    public DataInputStream getInputStream() {
        return this.is;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public DataOutputStream getOutpuStream() {
        return this.os;
    }

    @Override
    public synchronized void open() throws IOException {
        if (!this.closed) {
            throw new IOException("Connection has already been opened..");
        }
        this.socket = SocketFactory.getDefault().createSocket(this.settings.inetAddress(), this.settings.port());
        try {
            this.os = new DataOutputStream(new BufferedOutputStream(this.socket.getOutputStream()));
        }
        catch (IOException e) {
            TcpLayer.unsaveClose(this.socket);
            throw e;
        }
        try {
            this.is = new DataInputStream(new BufferedInputStream(this.socket.getInputStream()));
        }
        catch (IOException e) {
            TcpLayer.unsaveClose(this.os);
            throw e;
        }
        this.closed = false;
    }

    @Override
    public void close() throws IOException {
        if (!this.closed) {
            this.os.close();
            this.is.close();
            this.closed = true;
        }
    }

    private static void unsaveClose(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }
}

