/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.server;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.openmuc.jdlms.RawMessageData;
import org.openmuc.jdlms.internal.association.AssociationShutdownException;
import org.openmuc.jdlms.sessionlayer.client.HdlcSequenceNumber;
import org.openmuc.jdlms.sessionlayer.hdlc.FrameInvalidException;
import org.openmuc.jdlms.sessionlayer.hdlc.FrameType;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcAddressPair;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcFrame;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcFrameSegmentBuffer;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcMessageDecoder;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcParameters;
import org.openmuc.jdlms.sessionlayer.server.ServerSessionLayer;
import org.openmuc.jdlms.settings.server.ServerSettings;
import org.openmuc.jdlms.transportlayer.StreamAccessor;

public class ServerHdlcSessionLayer
implements ServerSessionLayer {
    private static final int INFORMATION_FRAME_OVERHEAD = 18;
    private final StreamAccessor streamAccessor;
    private final ServerSettings settings;
    private int logicalDeviceId;
    private int clientId;
    private HdlcAddressPair addressPair;
    private HdlcParameters negParams;
    private final HdlcSequenceNumber sendSequenceNum;
    private final HdlcSequenceNumber receiveSequenceNum;

    public ServerHdlcSessionLayer(StreamAccessor streamAccessor, ServerSettings settings) {
        this.streamAccessor = streamAccessor;
        this.settings = settings;
        this.logicalDeviceId = -1;
        this.clientId = -1;
        this.sendSequenceNum = new HdlcSequenceNumber();
        this.receiveSequenceNum = new HdlcSequenceNumber();
    }

    @Override
    public void initialize() throws IOException {
        HdlcParameters clientParams;
        HdlcFrame connectFrame;
        RawMessageData.RawMessageDataBuilder rawMessageBuilder = null;
        List<HdlcFrame> frames = HdlcMessageDecoder.decode(rawMessageBuilder, this.streamAccessor, this.settings.getResponseTimeout());
        if (frames.size() != 1) {
            // empty if block
        }
        if ((connectFrame = frames.get(0)).getFrameType() != FrameType.SET_NORMAL_RESPONSEMODE) {
            // empty if block
        }
        this.addressPair = connectFrame.getAddressPair().switchedPair();
        this.clientId = this.addressPair.destination().getLogicalId();
        this.logicalDeviceId = this.addressPair.source().getLogicalId();
        try {
            clientParams = HdlcParameters.decode(connectFrame.getInformationField());
        }
        catch (FrameInvalidException e) {
            throw new AssociationShutdownException();
        }
        int receiveInformationLength = Math.min(2030, clientParams.getTransmitInformationLength());
        int receiveWindowSize = 1;
        int transmitInformationLength = Math.min(2030, clientParams.getReceiveInformationLength());
        int transmitWindowSize = 1;
        this.negParams = new HdlcParameters(receiveInformationLength, receiveWindowSize, transmitInformationLength, transmitWindowSize);
        boolean finalFlag = true;
        byte[] responseFrame = HdlcFrame.newUnnumberedAcknowledgeFrame(this.addressPair, this.negParams, finalFlag).encode();
        this.writeToStream(responseFrame);
    }

    @Override
    public byte[] readNextMessage() throws IOException {
        RawMessageData.RawMessageDataBuilder rawMessageBuilder = null;
        HdlcFrame incommingFrame = HdlcMessageDecoder.decode(rawMessageBuilder, this.streamAccessor, this.settings.getResponseTimeout()).get(0);
        incommingFrame.getAddressPair();
        switch (incommingFrame.getFrameType()) {
            case INFORMATION: {
                return this.handleIncomingInfoFrame(incommingFrame);
            }
            case DISCONNECT: {
                boolean finalFrame = true;
                HdlcFrame disconnectAck = HdlcFrame.newUnnumberedAcknowledgeFrame(this.addressPair, this.negParams, finalFrame);
                this.writeToStream(disconnectAck.encode());
                throw new AssociationShutdownException();
            }
        }
        throw new IOException();
    }

    private byte[] handleIncomingInfoFrame(HdlcFrame incommingFrame) throws IOException {
        if (incommingFrame.isSegmented()) {
            return this.readSegmentsFromClient(incommingFrame);
        }
        return incommingFrame.getInformationFieldWithoutLlc();
    }

    private byte[] readSegmentsFromClient(HdlcFrame incommingFrame) throws IOException {
        HdlcFrameSegmentBuffer segmentBuffer = new HdlcFrameSegmentBuffer();
        segmentBuffer.buffer(incommingFrame);
        do {
            this.sendReceiveReady(incommingFrame.getReceiveSequence());
            incommingFrame = HdlcMessageDecoder.decode(null, this.streamAccessor, this.settings.getResponseTimeout()).get(0);
            if (incommingFrame.getFrameType() != FrameType.INFORMATION) {
                // empty if block
            }
            segmentBuffer.buffer(incommingFrame);
        } while (incommingFrame.isSegmented());
        return segmentBuffer.toByteArray();
    }

    private void sendReceiveReady(int sequenceNumber) throws IOException {
        HdlcFrame receiveReadyFrame = HdlcFrame.newReceiveReadyFrame(this.addressPair, sequenceNumber, false);
        this.writeToStream(receiveReadyFrame.encode());
    }

    @Override
    public void send(byte[] data) throws IOException {
        if (data.length + 18 >= this.negParams.getTransmitInformationLength()) {
            this.sendAsSegments(data);
        } else {
            boolean segmented = false;
            this.writeToStream(this.infoFrameDataFor(data, segmented));
        }
    }

    private void writeToStream(byte[] dataToSend) throws IOException {
        this.streamAccessor.getOutpuStream().write(dataToSend);
        this.streamAccessor.getOutpuStream().flush();
    }

    private void sendAsSegments(byte[] data) throws IOException {
        byte[] segment = new byte[this.segmentLength()];
        ByteBuffer segmentBuffer = ByteBuffer.wrap(data);
        boolean first = true;
        this.sendSegment(segment, segmentBuffer, first);
        first = false;
        while (true) {
            this.waitForRRFrame();
            this.sendSegment(segment, segmentBuffer, first);
            if (segmentBuffer.remaining() >= this.segmentLength()) continue;
            if (!segmentBuffer.hasRemaining()) {
                return;
            }
            segment = new byte[segmentBuffer.remaining()];
        }
    }

    private void waitForRRFrame() throws IOException {
        HdlcFrame rrFrame = HdlcMessageDecoder.decode(null, this.streamAccessor, this.settings.getResponseTimeout()).get(0);
        if (rrFrame.getFrameType() != FrameType.RECEIVE_READY) {
            System.err.println((Object)rrFrame.getFrameType());
        }
    }

    private void sendSegment(byte[] segment, ByteBuffer buffer, boolean first) throws IOException {
        buffer.get(segment);
        boolean segmented = buffer.hasRemaining();
        byte[] frameData = this.infoFrameDataFor(segment, segmented, first);
        this.writeToStream(frameData);
    }

    private int segmentLength() {
        return this.negParams.getTransmitInformationLength() - 18;
    }

    private byte[] infoFrameDataFor(byte[] segment, boolean segmented) {
        return this.infoFrameDataFor(segment, segmented, true);
    }

    private byte[] infoFrameDataFor(byte[] segment, boolean segmented, boolean addLlc) {
        return HdlcFrame.newInformationFrame(this.addressPair, this.sendSequenceNum.increment(), this.receiveSequenceNum.getValue(), segment, segmented, addLlc).encode();
    }

    @Override
    public int getClientId() {
        return this.clientId;
    }

    @Override
    public int getLogicalDeviceId() {
        return this.logicalDeviceId;
    }

    @Override
    public void close() throws IOException {
        this.streamAccessor.close();
    }
}

