/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.hdlc;

import java.io.DataInputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.LinkedList;
import java.util.List;
import org.openmuc.jdlms.FatalJDlmsException;
import org.openmuc.jdlms.JDlmsException;
import org.openmuc.jdlms.RawMessageData;
import org.openmuc.jdlms.sessionlayer.hdlc.FrameInvalidException;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcFrame;
import org.openmuc.jdlms.transportlayer.StreamAccessor;

public class HdlcMessageDecoder {
    private static final int HDLC_LENGTH_MASK = 2047;
    private static final byte HDLC_FLAG = 126;

    public static List<HdlcFrame> decode(RawMessageData.RawMessageDataBuilder rawMessageBuilder, StreamAccessor streamAccessor, int timeout) throws IOException {
        DataInputStream iStream = streamAccessor.getInputStream();
        LinkedList<HdlcFrame> frames = new LinkedList<HdlcFrame>();
        streamAccessor.setTimeout(0);
        HdlcMessageDecoder.validateFlag(iStream.readByte());
        do {
            byte[] frameBytes = HdlcMessageDecoder.readFrame(iStream, streamAccessor, timeout);
            if (rawMessageBuilder != null) {
                rawMessageBuilder.setMessageSource(RawMessageData.MessageSource.SERVER);
                rawMessageBuilder.setMessage(ByteBuffer.allocate(frameBytes.length + 2).put((byte)126).put(frameBytes).put((byte)126).array());
            }
            HdlcMessageDecoder.validateFlag(iStream.readByte());
            try {
                frames.add(HdlcFrame.decode(frameBytes));
            }
            catch (FrameInvalidException frameInvalidException) {
                // empty catch block
            }
        } while (iStream.available() > 0);
        return frames;
    }

    private static byte[] readFrame(DataInputStream iStream, StreamAccessor streamAccessor, int timeout) throws IOException {
        short frameFormat = iStream.readShort();
        if (streamAccessor != null) {
            streamAccessor.setTimeout(timeout);
        }
        int length = 0x7FF & frameFormat;
        byte[] data = new byte[length];
        data[0] = (byte)((frameFormat & 0xFF00) >> 8);
        data[1] = (byte)(frameFormat & 0xFF);
        iStream.readFully(data, 2, length - 2);
        return data;
    }

    private static void validateFlag(byte flag) throws FatalJDlmsException {
        if (flag != 126) {
            throw new FatalJDlmsException(JDlmsException.ExceptionId.HDLC_MSG_INVALID_FLAG, JDlmsException.Fault.SYSTEM, String.format("Expected starting/ending Flag 0x7E, but received: 0x%02X.", flag));
        }
    }

    private HdlcMessageDecoder() {
    }
}

