/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.hdlc;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcFrame;

public class HdlcFrameSegmentBuffer {
    private final List<HdlcFrame> segments = new LinkedList<HdlcFrame>();

    public void buffer(HdlcFrame segment) {
        this.segments.add(segment);
    }

    public boolean isEmpty() {
        return this.segments.isEmpty();
    }

    public byte[] toByteArray() {
        Iterator<HdlcFrame> iter = this.segments.iterator();
        if (!iter.hasNext()) {
            return new byte[0];
        }
        ByteArrayOutputStream bios = new ByteArrayOutputStream();
        try {
            HdlcFrame next = iter.next();
            bios.write(next.getInformationFieldWithoutLlc());
            while (iter.hasNext()) {
                next = iter.next();
                bios.write(next.getInformationField());
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return bios.toByteArray();
    }

    public void clear() {
        this.segments.clear();
    }

    public byte[] concatFramesBytes() {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        byteArrayOutputStream.write(126);
        for (HdlcFrame hdlcFrame : this.segments) {
            try {
                byteArrayOutputStream.write(hdlcFrame.encodeWithoutFlags());
            }
            catch (IOException iOException) {
                // empty catch block
            }
            byteArrayOutputStream.write(126);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

