/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.hdlc;

import org.openmuc.jdlms.sessionlayer.hdlc.HdlcAddress;

public class HdlcAddressPair {
    private final HdlcAddress source;
    private final HdlcAddress destination;

    public HdlcAddressPair(HdlcAddress source, HdlcAddress destination) {
        this.source = source;
        this.destination = destination;
    }

    public HdlcAddress source() {
        return this.source;
    }

    public HdlcAddress destination() {
        return this.destination;
    }

    public HdlcAddressPair switchedPair() {
        return new HdlcAddressPair(this.destination, this.source);
    }

    public int hashCode() {
        int hashSource = this.source != null ? this.source.getPhysicalId() + this.source.getLogicalId() : 0;
        int hashDestination = this.destination != null ? this.destination.getPhysicalId() + this.destination.getLogicalId() : 0;
        return (hashSource + hashDestination) * hashDestination + hashSource;
    }

    public boolean equals(Object o) {
        if (!(o instanceof HdlcAddressPair)) {
            return false;
        }
        HdlcAddressPair other = (HdlcAddressPair)o;
        return this.source.equals(other.source) && this.destination.equals(other.destination) || this.source.equals(other.source) && other.destination.isCalling();
    }

    public String toString() {
        return this.source + ":" + this.destination;
    }
}

