/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.hdlc;

public enum FrameType {
    INFORMATION(0, 1),
    RECEIVE_READY(1, 15),
    RECEIVE_NOT_READY(5, 15),
    SET_NORMAL_RESPONSEMODE(131, 239),
    DISCONNECT(67, 239),
    UNNUMBERED_ACKNOWLEDGE(99, 239),
    DISCONNECT_MODE(15, 239),
    FRAME_REJECT(135, 239),
    UNNUMBERED_INFORMATION(192, 239),
    ERR_INVALID_TYPE(255, 255);

    private byte value;
    private int mask;

    private FrameType(int value, int mask) {
        this.value = (byte)value;
        this.mask = mask;
    }

    public byte value() {
        return this.value;
    }

    public static FrameType frameTypeFor(int controlByte) {
        for (FrameType frameType : FrameType.values()) {
            if ((byte)(controlByte & frameType.mask) != frameType.value) continue;
            return frameType;
        }
        return ERR_INVALID_TYPE;
    }
}

