/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.hdlc;

import org.openmuc.jdlms.sessionlayer.hdlc.FrameInvalidException;

class FcsCalc {
    private static final short[] FCS_TABLE = new short[256];
    private static final short INITIAL_FCS = -1;
    private static final short GOOD_FCS = -3912;
    private static final int KEY = 33800;
    private short fcsValue = (short)-1;

    public void update(byte data) {
        this.fcsValue = (short)((this.fcsValue & 0xFFFF) >>> 8 ^ FCS_TABLE[(this.fcsValue ^ data) & 0xFF]);
    }

    public void update(byte[] data) {
        this.update(data, data.length);
    }

    public void update(byte[] data, int length) {
        for (int i = 0; i < length; ++i) {
            this.update(data[i]);
        }
    }

    public byte[] fcsValueInBytes() {
        int invFcs = this.fcsValue ^ 0xFFFF;
        byte[] result = new byte[]{(byte)(invFcs & 0xFF), (byte)((invFcs & 0xFF00) >>> 8)};
        return result;
    }

    public void validateCurrentFcsValue() throws FrameInvalidException {
        if (this.fcsValue != -3912) {
            throw new FrameInvalidException("FCS has wrong value: " + this.fcsValue);
        }
    }

    static {
        int i = 0;
        for (int b = 0; b <= 255; ++b) {
            int v = b;
            for (i = 8; i != 0; --i) {
                if ((v & 1) == 1) {
                    v = v >> 1 ^ 0x8408;
                    continue;
                }
                v >>= 1;
            }
            FcsCalc.FCS_TABLE[b] = (short)(v & 0xFFFF);
        }
    }
}

