/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.client;

import java.io.DataInputStream;
import java.io.IOException;
import org.openmuc.jdlms.FatalJDlmsException;
import org.openmuc.jdlms.JDlmsException;
import org.openmuc.jdlms.sessionlayer.client.WrapperHeader;
import org.openmuc.jdlms.settings.client.Settings;
import org.openmuc.jdlms.transportlayer.StreamAccessor;

public class WrapperPdu {
    private final WrapperHeader header;
    private final byte[] data;

    private WrapperPdu(WrapperHeader header, byte[] data) {
        this.header = header;
        this.data = data;
    }

    public byte[] getData() {
        return this.data;
    }

    public WrapperHeader getheader() {
        return this.header;
    }

    public static WrapperPdu decode(StreamAccessor transportLayer, Settings settings) throws IOException {
        DataInputStream inputStream = transportLayer.getInputStream();
        transportLayer.setTimeout(0);
        WrapperHeader header = WrapperHeader.decode(transportLayer, settings.responseTimeout());
        byte[] messageData = new byte[header.getPayloadLength()];
        inputStream.readFully(messageData);
        WrapperPdu.validate(header, settings);
        return new WrapperPdu(header, messageData);
    }

    private static void validate(WrapperHeader header, Settings settings) throws FatalJDlmsException {
        if (header.getSourceWPort() != settings.logicalDeviceId()) {
            throw new FatalJDlmsException(JDlmsException.ExceptionId.WRAPPER_HEADER_INVALID_SRC_DEST_ADDR, JDlmsException.Fault.SYSTEM, String.format("Connection was initiated with logical device address %d, but server answered with %d", settings.logicalDeviceId(), header.getSourceWPort()));
        }
    }
}

