/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.client;

import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.openmuc.jdlms.RawMessageData;
import org.openmuc.jdlms.RawMessageListener;
import org.openmuc.jdlms.sessionlayer.client.SessionLayer;
import org.openmuc.jdlms.sessionlayer.client.SessionLayerListener;
import org.openmuc.jdlms.sessionlayer.client.WrapperHeader;
import org.openmuc.jdlms.sessionlayer.client.WrapperPdu;
import org.openmuc.jdlms.settings.client.Settings;
import org.openmuc.jdlms.transportlayer.client.TransportLayer;

public class WrapperLayer
implements SessionLayer {
    private SessionLayerListener eventListener;
    private final WrapperHeader.WrapperHeaderBuilder headerBuilder;
    private final TransportLayer transportLayer;
    private final Settings settings;
    private boolean closed;
    private final ExecutorService exec;
    private DataOutputStream outpuStream;

    public WrapperLayer(Settings settings, TransportLayer transportLayer) throws IOException {
        this.settings = settings;
        this.headerBuilder = WrapperHeader.builder(settings.clientId(), settings.logicalDeviceId());
        this.transportLayer = transportLayer;
        this.closed = true;
        this.exec = Executors.newSingleThreadExecutor();
    }

    @Override
    public void startListening(SessionLayerListener eventListener) throws IOException {
        if (!this.closed) {
            return;
        }
        this.eventListener = eventListener;
        this.transportLayer.open();
        this.closed = false;
        this.outpuStream = this.transportLayer.getOutpuStream();
        this.exec.execute(new ConnectionReader());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void send(byte[] tSdu, int off, int len, RawMessageData.RawMessageDataBuilder rawMessageDataBuilder) throws IOException {
        byte[] headerBytes = this.headerBuilder.setLength(len).build().encode();
        byte[] wpdu = ByteBuffer.allocate(len + 8).put(headerBytes).put(tSdu, off, len).array();
        try {
            this.outpuStream.write(wpdu);
            this.outpuStream.flush();
        }
        finally {
            RawMessageListener rawMessageListener = this.settings.rawMessageListener();
            if (rawMessageListener != null) {
                rawMessageListener.messageCaptured(rawMessageDataBuilder.setMessage(wpdu).setMessageSource(RawMessageData.MessageSource.CLIENT).build());
            }
        }
    }

    @Override
    public void close() throws IOException {
        if (this.closed) {
            return;
        }
        this.exec.shutdown();
        this.transportLayer.close();
        this.closed = true;
    }

    private void unsaveClose() {
        if (this.closed) {
            return;
        }
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private class ConnectionReader
    implements Runnable {
        private ConnectionReader() {
        }

        @Override
        public void run() {
            Thread.currentThread().setName("jDLMS - WRAPPER/INET-CONNECTION-READER thread");
            try {
                while (!WrapperLayer.this.transportLayer.isClosed()) {
                    WrapperPdu wrapperPdu = WrapperPdu.decode(WrapperLayer.this.transportLayer, WrapperLayer.this.settings);
                    RawMessageData.RawMessageDataBuilder rawMessageBuilder = this.createMsgBuilder(wrapperPdu);
                    WrapperLayer.this.eventListener.dataReceived(wrapperPdu.getData(), rawMessageBuilder);
                    Thread.yield();
                }
            }
            catch (EOFException e) {
                if (!WrapperLayer.this.closed) {
                    EOFException ex = new EOFException("Socket was closed by remote host.");
                    WrapperLayer.this.eventListener.connectionInterrupted(ex);
                }
            }
            catch (IOException e) {
                WrapperLayer.this.eventListener.connectionInterrupted(e);
            }
            finally {
                WrapperLayer.this.unsaveClose();
            }
        }

        private RawMessageData.RawMessageDataBuilder createMsgBuilder(WrapperPdu wrapperPdu) {
            if (WrapperLayer.this.settings.rawMessageListener() == null) {
                return null;
            }
            WrapperHeader header = wrapperPdu.getheader();
            byte[] message = ByteBuffer.allocate(8 + header.getPayloadLength()).put(header.encode()).put(wrapperPdu.getData()).array();
            return RawMessageData.builder().setMessage(message);
        }
    }
}

