/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.sessionlayer.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.openmuc.jdlms.FatalJDlmsException;
import org.openmuc.jdlms.JDlmsException;
import org.openmuc.jdlms.RawMessageData;
import org.openmuc.jdlms.RawMessageListener;
import org.openmuc.jdlms.sessionlayer.client.HdlcSequenceNumber;
import org.openmuc.jdlms.sessionlayer.client.SessionLayer;
import org.openmuc.jdlms.sessionlayer.client.SessionLayerListener;
import org.openmuc.jdlms.sessionlayer.hdlc.FrameType;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcAddressPair;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcDispatcher;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcFrame;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcFrameSegmentBuffer;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcMessageQueue;
import org.openmuc.jdlms.sessionlayer.hdlc.HdlcParameters;
import org.openmuc.jdlms.settings.client.HdlcSettings;

public class HdlcLayer
implements SessionLayer {
    private SessionLayerListener connectionListener;
    private final HdlcSettings settings;
    private HdlcSequenceNumber sendSeqNum;
    private HdlcSequenceNumber recSeqNum;
    private final HdlcMessageQueue sendQueue;
    private int sendWindowSize;
    private int sendInformationLength;
    private boolean closed;
    private final HdlcDispatcher.HdlcConnection hdlcConnection;

    public HdlcLayer(HdlcSettings settings) {
        this.settings = settings;
        this.sendSeqNum = new HdlcSequenceNumber();
        this.recSeqNum = new HdlcSequenceNumber();
        this.sendQueue = new HdlcMessageQueue(1);
        this.closed = true;
        this.hdlcConnection = HdlcDispatcher.instance().connect(settings, new HdlcConnectionListenerImpl());
    }

    @Override
    public synchronized void startListening(SessionLayerListener listener) throws IOException {
        this.connectionListener = listener;
        HdlcParameters parameterNegotiation = this.hdlcConnection.open(this.settings);
        this.sendInformationLength = parameterNegotiation.getReceiveInformationLength();
        this.sendWindowSize = parameterNegotiation.getReceiveWindowSize();
        this.closed = false;
    }

    @Override
    public synchronized void send(byte[] tSdu, int off, int len, RawMessageData.RawMessageDataBuilder rawMessageDataBuilder) throws IOException {
        int toIndex = off + len;
        byte[] data = Arrays.copyOfRange(tSdu, off, toIndex);
        if (len > this.maxMessageLength()) {
            this.sendAsSegments(rawMessageDataBuilder, data);
        } else {
            boolean segmented = false;
            boolean addLlc = true;
            this.sendInfoFrame(rawMessageDataBuilder, data, segmented, addLlc);
        }
    }

    private void sendAsSegments(RawMessageData.RawMessageDataBuilder rawMessageDataBuilder, byte[] data) throws IOException {
        ByteBuffer segmentBufferBuffer = ByteBuffer.wrap(data);
        byte[] segment = new byte[this.sendInformationLength - 12];
        boolean addLlc = true;
        this.sendSegment(rawMessageDataBuilder, segmentBufferBuffer, segment, addLlc);
        addLlc = false;
        while (true) {
            this.sendSegment(rawMessageDataBuilder, segmentBufferBuffer, segment, addLlc);
            if (segmentBufferBuffer.remaining() >= segment.length) continue;
            if (!segmentBufferBuffer.hasRemaining()) {
                return;
            }
            segment = new byte[segmentBufferBuffer.remaining()];
        }
    }

    private void sendSegment(RawMessageData.RawMessageDataBuilder rawMessageDataBuilder, ByteBuffer segmentBufferBuffer, byte[] segment, boolean addLlc) throws IOException {
        segmentBufferBuffer.get(segment);
        boolean segmented = segmentBufferBuffer.hasRemaining();
        this.sendInfoFrame(rawMessageDataBuilder, segment, segmented, addLlc);
    }

    private int maxMessageLength() {
        return this.sendInformationLength * this.sendWindowSize;
    }

    @Override
    public synchronized void close() throws IOException {
        if (this.closed) {
            throw new FatalJDlmsException(JDlmsException.ExceptionId.CONNECTION_ALREADY_CLOSED, JDlmsException.Fault.USER, "Connection has been already closed.");
        }
        try {
            this.hdlcConnection.disconnect(this.settings);
        }
        finally {
            this.closed = true;
            this.sendSeqNum = null;
            this.recSeqNum = null;
            this.sendQueue.clear();
        }
    }

    private void closeUnsafe() {
        try {
            this.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void sendInfoFrame(RawMessageData.RawMessageDataBuilder rawMessageDataBuilder, byte[] data, boolean segmented, boolean addLlc) throws IOException {
        HdlcAddressPair addressPair = this.settings.addressPair();
        HdlcFrame frame = HdlcFrame.newInformationFrame(addressPair, this.sendSeqNum.increment(), this.recSeqNum.getValue(), data, segmented, addLlc);
        this.sendAndBufferFrame(rawMessageDataBuilder, frame);
    }

    private void sendAndBufferFrame(RawMessageData.RawMessageDataBuilder rawMessageDataBuilder, HdlcFrame infoFrame) throws IOException {
        byte[] dataToSend = infoFrame.encode();
        this.sendQueue.offerMessage(dataToSend, infoFrame.getSendSequence());
        RawMessageListener rawMessageListener = this.settings.rawMessageListener();
        if (rawMessageListener != null) {
            RawMessageData rawMessageData = rawMessageDataBuilder.setMessageSource(RawMessageData.MessageSource.CLIENT).setMessage(dataToSend).build();
            rawMessageListener.messageCaptured(rawMessageData);
        }
        this.hdlcConnection.send(dataToSend);
    }

    private void notifyRawMessageListener(byte[] data, RawMessageData.MessageSource messageSource) {
        if (this.settings.rawMessageListener() == null) {
            return;
        }
        RawMessageData rawMessageData = RawMessageData.builder().setMessageSource(messageSource).setMessage(data).build();
        this.settings.rawMessageListener().messageCaptured(rawMessageData);
    }

    private class HdlcConnectionListenerImpl
    implements HdlcDispatcher.HdlcConnectionListener {
        private final HdlcFrameSegmentBuffer segmentBuffer = new HdlcFrameSegmentBuffer();

        private void sendAcknowledge() throws IOException {
            boolean poll = true;
            byte[] ackFrame = HdlcFrame.newReceiveReadyFrame(HdlcLayer.this.settings.addressPair(), HdlcLayer.this.recSeqNum.getValue(), poll).encode();
            RawMessageData.MessageSource messageSource = RawMessageData.MessageSource.CLIENT;
            HdlcLayer.this.notifyRawMessageListener(ackFrame, messageSource);
            try {
                HdlcLayer.this.hdlcConnection.send(ackFrame);
            }
            catch (InterruptedIOException interruptedIOException) {
                // empty catch block
            }
        }

        @Override
        public void dataReceived(RawMessageData.RawMessageDataBuilder rawMessageDataBuilder, HdlcFrame frame) {
            HdlcLayer.this.recSeqNum.increment();
            if (frame.isSegmented()) {
                this.segmentBuffer.buffer(frame);
                this.notifyListener(rawMessageDataBuilder);
                try {
                    this.sendAcknowledge();
                }
                catch (IOException e) {
                    HdlcLayer.this.closeUnsafe();
                    this.connectionInterrupted(e);
                    return;
                }
            } else if (frame.getFrameType() == FrameType.INFORMATION) {
                byte[] cosemFrame;
                this.acknowledgeSendFramesTil(frame.getReceiveSequence());
                if (!this.segmentBuffer.isEmpty()) {
                    this.segmentBuffer.buffer(frame);
                    this.notifyListener(rawMessageDataBuilder);
                    if (HdlcLayer.this.settings.rawMessageListener() != null) {
                        rawMessageDataBuilder.setMessage(this.segmentBuffer.concatFramesBytes());
                    }
                    cosemFrame = this.segmentBuffer.toByteArray();
                    this.segmentBuffer.clear();
                } else {
                    cosemFrame = frame.getInformationFieldWithoutLlc();
                }
                HdlcLayer.this.connectionListener.dataReceived(cosemFrame, rawMessageDataBuilder);
            } else if (frame.getFrameType() == FrameType.RECEIVE_READY) {
                this.acknowledgeSendFramesTil(frame.getReceiveSequence());
                this.sendQueuedFrames();
            }
        }

        private void notifyListener(RawMessageData.RawMessageDataBuilder rawMessageDataBuilder) {
            if (HdlcLayer.this.settings.rawMessageListener() != null) {
                RawMessageData rawMessageData = rawMessageDataBuilder.build();
                HdlcLayer.this.settings.rawMessageListener().messageCaptured(rawMessageData);
            }
        }

        private void acknowledgeSendFramesTil(int sendSeq) {
            if (sendSeq == 0) {
                sendSeq = 8;
            }
            HdlcLayer.this.sendQueue.clearTil(sendSeq);
        }

        @Override
        public void connectionInterrupted(IOException e) {
            HdlcLayer.this.connectionListener.connectionInterrupted(e);
        }

        private void sendQueuedFrames() {
            try {
                for (byte[] message : HdlcLayer.this.sendQueue) {
                    HdlcLayer.this.hdlcConnection.send(message);
                }
            }
            catch (IOException e) {
                HdlcLayer.this.closeUnsafe();
                HdlcLayer.this.connectionListener.connectionInterrupted(e);
            }
        }
    }
}

