/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.systemclasses;

import java.nio.charset.StandardCharsets;
import java.util.LinkedList;
import org.openmuc.jdlms.AttributeAccessMode;
import org.openmuc.jdlms.CosemAttribute;
import org.openmuc.jdlms.CosemClass;
import org.openmuc.jdlms.CosemSnInterfaceObject;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.DataDirectoryImpl;
import org.openmuc.jdlms.internal.systemclasses.CosemDataDirectory;

@CosemClass(id=17, version=0)
public class SapAssignment
extends CosemSnInterfaceObject {
    private static final int SAP_ASSIGNMENT_BASE_NAME = 64256;
    @CosemAttribute(id=2, accessMode=AttributeAccessMode.READ_ONLY, snOffset=8)
    private DataObject sapAssignmentList;
    @CosemDataDirectory
    private DataDirectoryImpl directory;

    public SapAssignment() {
        super(64256, "0.0.41.0.0.255");
    }

    public DataObject getSapAssignmentList() {
        if (this.sapAssignmentList != null) {
            return this.sapAssignmentList;
        }
        LinkedList<DataObject> assListElements = new LinkedList<DataObject>();
        for (Integer logicalDeviceId : this.directory.getLogicalDeviceIds()) {
            byte[] logicalDeviceNameBytes = this.directory.getLogicalDeviceFor(logicalDeviceId).getLogicalDevice().getLogicalDeviceName().getBytes(StandardCharsets.US_ASCII);
            DataObject sap = DataObject.newUInteger16Data(logicalDeviceId);
            DataObject logicalDeviceNameDO = DataObject.newOctetStringData(logicalDeviceNameBytes);
            DataObject assListElement = DataObject.newStructureData(sap, logicalDeviceNameDO);
            assListElements.add(assListElement);
        }
        this.sapAssignmentList = DataObject.newArrayData(assListElements);
        return this.sapAssignmentList;
    }
}

