/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.systemclasses;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import org.openmuc.jdlms.AccessResultCode;
import org.openmuc.jdlms.AttributeAccessMode;
import org.openmuc.jdlms.AuthenticationMechanism;
import org.openmuc.jdlms.ConformanceSetting;
import org.openmuc.jdlms.CosemAttribute;
import org.openmuc.jdlms.CosemClass;
import org.openmuc.jdlms.CosemInterfaceObject;
import org.openmuc.jdlms.CosemMethod;
import org.openmuc.jdlms.IllegalAttributeAccessException;
import org.openmuc.jdlms.IllegalMethodAccessException;
import org.openmuc.jdlms.LogicalDevice;
import org.openmuc.jdlms.MethodAccessMode;
import org.openmuc.jdlms.MethodResultCode;
import org.openmuc.jdlms.ObisCode;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.SelectiveAccessDescription;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.AttributeAccessor;
import org.openmuc.jdlms.internal.ConformanceSettingConverter;
import org.openmuc.jdlms.internal.DataDirectoryImpl;
import org.openmuc.jdlms.internal.MethodAccessor;
import org.openmuc.jdlms.internal.ServerConnectionData;
import org.openmuc.jdlms.internal.asn1.cosem.Conformance;
import org.openmuc.jdlms.internal.security.authentication.HlsProcessorGmac;
import org.openmuc.jdlms.internal.security.authentication.HlsSecretProcessor;
import org.openmuc.jdlms.internal.systemclasses.CosemDataDirectory;

@CosemClass(id=15, version=1)
public class AssociationLnClass
extends CosemInterfaceObject {
    private static final int FILTER_ACCESS_RIGHTS = 1;
    private static final int FILTER_CLASS_LIST = 2;
    private static final int FILTER_OBJECT_ID_LIST = 3;
    private static final int FILTER_OBJECT_ID = 4;
    @CosemAttribute(id=2, accessMode=AttributeAccessMode.READ_ONLY, type=DataObject.Type.ARRAY, selector={1, 2, 3, 4})
    private DataObject objectList;
    @CosemAttribute(id=3, accessMode=AttributeAccessMode.READ_ONLY, type=DataObject.Type.STRUCTURE)
    private DataObject associationPartners;
    @CosemAttribute(id=4, accessMode=AttributeAccessMode.READ_ONLY)
    private DataObject applicationContextName;
    @CosemAttribute(id=5, accessMode=AttributeAccessMode.READ_ONLY)
    private DataObject authenticationMechanism;
    @CosemAttribute(id=6, accessMode=AttributeAccessMode.READ_ONLY, type=DataObject.Type.STRUCTURE)
    private DataObject xDlmsContextInfo;
    @CosemAttribute(id=7, accessMode=AttributeAccessMode.AUTHENTICATED_READ_AND_WRITE, type=DataObject.Type.OCTET_STRING)
    private DataObject secret;
    @CosemAttribute(id=8, accessMode=AttributeAccessMode.READ_ONLY, type=DataObject.Type.ENUMERATE)
    private DataObject assotiationStatus;
    @CosemAttribute(id=9, accessMode=AttributeAccessMode.READ_ONLY, type=DataObject.Type.OCTET_STRING)
    private final DataObject securitySetupReference;
    @CosemDataDirectory
    private DataDirectoryImpl dataDirectory;
    private final int logicalDeviceId;

    public AssociationLnClass(int logicalDeviceId) {
        super("0.0.40.0.0.255");
        this.logicalDeviceId = logicalDeviceId;
        this.securitySetupReference = DataObject.newOctetStringData(new ObisCode("0.0.43.0.0.255").bytes());
    }

    public DataObject getObjectList(SelectiveAccessDescription sel) throws IllegalAttributeAccessException {
        if (sel == null) {
            if (this.objectList != null) {
                return this.objectList;
            }
            boolean excludeAccessRights = false;
            this.objectList = this.buildFullObjectList(excludeAccessRights);
            return this.objectList;
        }
        return this.filterObjectListBy(sel);
    }

    private DataObject buildFullObjectList(boolean excludeAccessRights) {
        return this.buildObjectsList(excludeAccessRights, new Filter(){

            @Override
            public boolean passes(DataDirectoryImpl.CosemClassInstance cosemClassInstance) {
                return true;
            }
        });
    }

    private DataObject filterObjectListBy(SelectiveAccessDescription sel) throws IllegalAttributeAccessException {
        switch (sel.getAccessSelector()) {
            case 1: {
                boolean excludeAccessRights = true;
                return this.buildFullObjectList(excludeAccessRights);
            }
            case 2: {
                return this.filterForClassList(sel.getAccessParameter());
            }
            case 3: {
                return this.filterForObjectIdList(sel.getAccessParameter());
            }
            case 4: {
                return this.filterForObjectId(sel.getAccessParameter());
            }
        }
        throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
    }

    private DataObject filterForObjectId(DataObject accessParameter) throws IllegalAttributeAccessException {
        List<DataObject> struct = AssociationLnClass.extractObjectIdStruct(accessParameter);
        DataObject classIdDo = struct.get(0);
        DataObject logicalNameDo = struct.get(1);
        if (classIdDo.getType() != DataObject.Type.LONG_UNSIGNED || logicalNameDo.getType() != DataObject.Type.OCTET_STRING) {
            throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
        }
        DataDirectoryImpl.CosemLogicalDevice logicalDevice = this.dataDirectory.getLogicalDeviceFor(this.logicalDeviceId);
        byte[] logicalName = (byte[])logicalNameDo.getValue();
        DataDirectoryImpl.CosemClassInstance cosemClassInstance = logicalDevice.get(new ObisCode(logicalName));
        Integer classId = (Integer)classIdDo.getValue();
        if (cosemClassInstance.getCosemClass().id() == classId.intValue()) {
            return DataObject.newNullData();
        }
        boolean excludeAccessRights = false;
        return AssociationLnClass.buildObjectListElement(excludeAccessRights, cosemClassInstance);
    }

    private static List<DataObject> extractObjectIdStruct(DataObject dataObject) throws IllegalAttributeAccessException {
        if (dataObject.getType() != DataObject.Type.STRUCTURE) {
            throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
        }
        List struct = (List)dataObject.getValue();
        if (struct.size() != 2) {
            throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
        }
        return struct;
    }

    private DataObject filterForObjectIdList(DataObject accessParameter) throws IllegalAttributeAccessException {
        if (accessParameter.getType() != DataObject.Type.ARRAY) {
            throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
        }
        List objectIds = (List)accessParameter.getValue();
        if (objectIds.isEmpty()) {
            return DataObject.newNullData();
        }
        final HashMap<ObisCode, Integer> instanceIdClassIdMap = new HashMap<ObisCode, Integer>(objectIds.size());
        for (DataObject structDo : objectIds) {
            List<DataObject> struct = AssociationLnClass.extractObjectIdStruct(structDo);
            DataObject classIdDo = struct.get(0);
            DataObject logicalNameDo = struct.get(1);
            if (classIdDo.getType() != DataObject.Type.LONG_UNSIGNED || logicalNameDo.getType() != DataObject.Type.OCTET_STRING) {
                throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
            }
            Integer classId = (Integer)classIdDo.getValue();
            byte[] instanceId = (byte[])logicalNameDo.getValue();
            instanceIdClassIdMap.put(new ObisCode(instanceId), classId);
        }
        return this.buildObjectsList(new Filter(){

            @Override
            public boolean passes(DataDirectoryImpl.CosemClassInstance cosemClassInstance) {
                Integer classId = (Integer)instanceIdClassIdMap.get(cosemClassInstance.getInstance().getInstanceId());
                if (classId == null) {
                    return false;
                }
                return classId.intValue() == cosemClassInstance.getCosemClass().id();
            }
        });
    }

    private DataObject filterForClassList(DataObject accessParameter) throws IllegalAttributeAccessException {
        if (accessParameter.getType() != DataObject.Type.ARRAY) {
            throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
        }
        List classIds = (List)accessParameter.getValue();
        if (classIds.isEmpty()) {
            return DataObject.newNullData();
        }
        if (((DataObject)classIds.get(0)).getType() != DataObject.Type.LONG_UNSIGNED) {
            throw new IllegalAttributeAccessException(AccessResultCode.TYPE_UNMATCHED);
        }
        final HashSet<Integer> classIdSet = new HashSet<Integer>(classIds.size());
        for (DataObject classIdDo : classIds) {
            Integer classId = (Integer)classIdDo.getValue();
            classIdSet.add(classId);
        }
        return this.buildObjectsList(new Filter(){

            @Override
            public boolean passes(DataDirectoryImpl.CosemClassInstance cosemClassInstance) {
                return classIdSet.contains(cosemClassInstance.getCosemClass().id());
            }
        });
    }

    private DataObject buildObjectsList(Filter filter) {
        return this.buildObjectsList(false, filter);
    }

    private DataObject buildObjectsList(boolean excludeAccessRights, Filter filter) {
        DataDirectoryImpl.CosemLogicalDevice logicalDevice = this.dataDirectory.getLogicalDeviceFor(this.logicalDeviceId);
        LinkedList<DataObject> objectListElements = new LinkedList<DataObject>();
        for (ObisCode instanceId : logicalDevice.getInstanceIds()) {
            DataDirectoryImpl.CosemClassInstance cosemClassInstance = logicalDevice.get(instanceId);
            if (!filter.passes(cosemClassInstance)) continue;
            DataObject listElement = AssociationLnClass.buildObjectListElement(excludeAccessRights, cosemClassInstance);
            objectListElements.add(listElement);
        }
        return DataObject.newArrayData(objectListElements);
    }

    private static DataObject buildObjectListElement(boolean excludeAccessRights, DataDirectoryImpl.CosemClassInstance cosemClassInstance) {
        CosemClass cosemClass = cosemClassInstance.getCosemClass();
        ObisCode instanceId = cosemClassInstance.getInstance().getInstanceId();
        DataObject instanceIdDo = DataObject.newOctetStringData(instanceId.bytes());
        DataObject classId = DataObject.newUInteger16Data((short)cosemClass.id());
        DataObject version = DataObject.newUInteger8Data((short)cosemClass.version());
        Collection<AttributeAccessor> attributes = cosemClassInstance.getSortedAttributes();
        Collection<MethodAccessor> methods = cosemClassInstance.getSortedMethods();
        if (excludeAccessRights) {
            return DataObject.newStructureData(Arrays.asList(classId, version, instanceIdDo));
        }
        DataObject attributAccesItems = AssociationLnClass.buildAttributeAccessElementsStruct(attributes);
        DataObject methodAccesItems = AssociationLnClass.buildMethodAccessElementsStruct(methods);
        DataObject accessRightsStruct = DataObject.newStructureData(Arrays.asList(attributAccesItems, methodAccesItems));
        return DataObject.newStructureData(Arrays.asList(classId, version, instanceIdDo, accessRightsStruct));
    }

    private static DataObject buildMethodAccessElementsStruct(Collection<MethodAccessor> methods) {
        ArrayList<DataObject> attributeAccessItems = new ArrayList<DataObject>(methods.size());
        for (MethodAccessor actionMethod : methods) {
            CosemMethod methodProperties = actionMethod.getCosemMethod();
            DataObject methodId = DataObject.newInteger8Data(methodProperties.id());
            DataObject accessMod = DataObject.newEnumerateData((int)methodProperties.accessMode().getCode());
            DataObject attributeAccessItem = DataObject.newStructureData(Arrays.asList(methodId, accessMod));
            attributeAccessItems.add(attributeAccessItem);
        }
        return DataObject.newArrayData(attributeAccessItems);
    }

    private static DataObject buildAttributeAccessElementsStruct(Collection<AttributeAccessor> entries) {
        ArrayList<DataObject> attributeAccessItems = new ArrayList<DataObject>(entries.size());
        for (AttributeAccessor entry : entries) {
            CosemAttribute attributeProperties = entry.getCosemAttribute();
            DataObject attributeId = DataObject.newInteger8Data(attributeProperties.id());
            DataObject accessMode = DataObject.newEnumerateData((int)attributeProperties.accessMode().getCode());
            DataObject accessSelectors = AssociationLnClass.buildSelector(attributeProperties);
            List<DataObject> attributeAccessItem = Arrays.asList(attributeId, accessMode, accessSelectors);
            attributeAccessItems.add(DataObject.newStructureData(attributeAccessItem));
        }
        return DataObject.newArrayData(attributeAccessItems);
    }

    private static DataObject buildSelector(CosemAttribute attributeProperties) {
        DataObject accessSelectors;
        int[] selectors = attributeProperties.selector();
        if (selectors.length == 0) {
            accessSelectors = DataObject.newNullData();
        } else {
            ArrayList<DataObject> array = new ArrayList<DataObject>(selectors.length);
            for (int selector : selectors) {
                array.add(DataObject.newInteger8Data((byte)selector));
            }
            accessSelectors = DataObject.newArrayData(array);
        }
        return accessSelectors;
    }

    public DataObject getApplicationContextName() {
        if (this.applicationContextName == null) {
            Set<ConformanceSetting> conformanceSettings = this.dataDirectory.getLogicalDeviceFor(this.logicalDeviceId).getLogicalDevice().getConformance();
            Conformance conformance = ConformanceSettingConverter.conformanceFor(conformanceSettings);
            this.applicationContextName = DataObject.newOctetStringData(conformance.value);
        }
        return this.applicationContextName;
    }

    @CosemMethod(id=1, consumes=DataObject.Type.OCTET_STRING, accessMode=MethodAccessMode.ACCESS)
    public DataObject replyToHlsAuthentication(DataObject dataObject, Long connectionId) throws IllegalMethodAccessException {
        byte[] processedClientToServerChallenge;
        LogicalDevice logicalDevice = this.dataDirectory.getLogicalDeviceFor(this.logicalDeviceId).getLogicalDevice();
        ServerConnectionData connectionData = this.dataDirectory.getConnectionData(connectionId);
        SecuritySuite sec = logicalDevice.getRestrictions().get(connectionData.getClientId());
        byte[] receivedServerToClientChallenge = (byte[])dataObject.getValue();
        int clientFc = ByteBuffer.wrap(receivedServerToClientChallenge, 1, 4).getInt();
        HlsSecretProcessor secretProcessor = this.hlsSecretProcessorFor(sec.getAuthenticationMechanism());
        try {
            byte[] serverToClientChallenge = secretProcessor.process(connectionData.getServerToClientChallenge(), sec, connectionData.getClientSystemTitle(), clientFc);
            AssociationLnClass.checkChallengeEquality(serverToClientChallenge, receivedServerToClientChallenge);
        }
        catch (IOException e1) {
            throw new IllegalMethodAccessException(MethodResultCode.OTHER_REASON);
        }
        byte[] clientToServerChallenge = connectionData.getClientToServerChallenge();
        try {
            processedClientToServerChallenge = secretProcessor.process(clientToServerChallenge, sec, logicalDevice.getSystemTitle(), connectionData.getFrameCounter());
        }
        catch (IOException | UnsupportedOperationException e) {
            throw new IllegalMethodAccessException(MethodResultCode.OTHER_REASON);
        }
        connectionData.setAuthenticated();
        return DataObject.newOctetStringData(processedClientToServerChallenge);
    }

    private HlsSecretProcessor hlsSecretProcessorFor(AuthenticationMechanism authenticationMechanismId) throws IllegalMethodAccessException {
        HlsProcessorGmac secretProcessor;
        switch (authenticationMechanismId) {
            case HLS5_GMAC: {
                secretProcessor = new HlsProcessorGmac();
                break;
            }
            default: {
                throw new IllegalMethodAccessException(MethodResultCode.OTHER_REASON);
            }
        }
        return secretProcessor;
    }

    private static void checkChallengeEquality(byte[] serverToClientChallenge, byte[] receivedServerToClientChallenge) throws IllegalMethodAccessException {
        if (!Arrays.equals(receivedServerToClientChallenge, serverToClientChallenge)) {
            throw new IllegalMethodAccessException(MethodResultCode.OTHER_REASON);
        }
    }

    private static interface Filter {
        public boolean passes(DataDirectoryImpl.CosemClassInstance var1);
    }
}

