/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.association.sn;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.List;
import org.openmuc.jdlms.IllegalAttributeAccessException;
import org.openmuc.jdlms.IllegalMethodAccessException;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.APdu;
import org.openmuc.jdlms.internal.DataConverter;
import org.openmuc.jdlms.internal.DlmsEnumFunctions;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrBoolean;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOctetString;
import org.openmuc.jdlms.internal.asn1.cosem.COSEMpdu;
import org.openmuc.jdlms.internal.asn1.cosem.DataBlockResult;
import org.openmuc.jdlms.internal.asn1.cosem.ParameterizedAccess;
import org.openmuc.jdlms.internal.asn1.cosem.ReadRequest;
import org.openmuc.jdlms.internal.asn1.cosem.ReadResponse;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned16;
import org.openmuc.jdlms.internal.asn1.cosem.VariableAccessSpecification;
import org.openmuc.jdlms.internal.association.AssociationMessenger;
import org.openmuc.jdlms.internal.association.RequestProcessorData;
import org.openmuc.jdlms.internal.association.sn.SnRequestProcessorBase;

public class ReadRequestProcessor
extends SnRequestProcessorBase {
    public ReadRequestProcessor(AssociationMessenger associationMessenger, RequestProcessorData requestProcessorData) {
        super(associationMessenger, requestProcessorData);
    }

    @Override
    public void processRequest(COSEMpdu request) throws IOException {
        ReadRequest readReq = request.readRequest;
        List list = readReq.list();
        ReadResponse readRes = new ReadResponse();
        for (VariableAccessSpecification varAccessSpec : list) {
            switch (varAccessSpec.getChoiceIndex()) {
                case VARIABLE_NAME: {
                    readRes.add(this.varNameAccess(varAccessSpec));
                    break;
                }
                case PARAMETERIZED_ACCESS: {
                    readRes.add(this.varParamAccess(varAccessSpec));
                    break;
                }
                case READ_DATA_BLOCK_ACCESS: {
                    break;
                }
            }
        }
        APdu aPdu = this.newAPdu();
        aPdu.getCosemPdu().setReadResponse(readRes);
        byte[] encodedApdu = this.associationMessenger.encode(aPdu);
        if (!this.associationMessenger.apduTooLarge(encodedApdu.length)) {
            this.associationMessenger.send(encodedApdu);
        } else {
            this.sendResposneAsBlocks(readRes, encodedApdu);
        }
    }

    private void sendResposneAsBlocks(ReadResponse readRes, byte[] encodedApdu) throws IOException {
        boolean lastBlock;
        readRes.encodeAndSave(encodedApdu.length);
        byte[] rawDataToSend = readRes.getCode();
        int expectedApduOverhead = encodedApdu.length - rawDataToSend.length;
        ByteBuffer rawDataBuffer = ByteBuffer.wrap(rawDataToSend);
        long blockNumber = 1L;
        int blockSize = this.associationMessenger.getMaxMessageLength() - expectedApduOverhead;
        byte[] blockVal = new byte[blockSize];
        do {
            rawDataBuffer.get(blockVal);
            lastBlock = !rawDataBuffer.hasRemaining();
            ReadResponse blockResponse = new ReadResponse();
            ReadResponse.SubChoice block = new ReadResponse.SubChoice();
            DataBlockResult blockData = new DataBlockResult(new AxdrBoolean(lastBlock), new Unsigned16(blockNumber++), new AxdrOctetString(blockVal));
            block.setDataBlockResult(blockData);
            blockResponse.add(block);
            APdu blockApdu = this.newAPdu();
            blockApdu.getCosemPdu().setReadResponse(blockResponse);
            this.associationMessenger.encodeAndSend(blockApdu);
            if (rawDataBuffer.remaining() < blockVal.length) {
                if (lastBlock) break;
                blockVal = new byte[rawDataBuffer.remaining()];
            }
            this.veifyBlockNumberAccessResponse(blockNumber);
        } while (!lastBlock);
    }

    private void veifyBlockNumberAccessResponse(long blockNumber) throws IOException {
        long blockNumRes;
        VariableAccessSpecification blockNumSpec;
        COSEMpdu cosemPdu = this.associationMessenger.readNextApdu().getCosemPdu();
        if (cosemPdu == null || cosemPdu.getChoiceIndex() != COSEMpdu.Choices.READREQUEST) {
            throw new IOException("Wrong COSEM PDU: " + cosemPdu);
        }
        ReadRequest readRequest = cosemPdu.readRequest;
        if (readRequest.size() != 1) {
            // empty if block
        }
        if ((blockNumSpec = (VariableAccessSpecification)readRequest.get(0)).getChoiceIndex() != VariableAccessSpecification.Choices.BLOCK_NUMBER_ACCESS) {
            // empty if block
        }
        if ((blockNumRes = blockNumSpec.blockNumberAccess.blockNumber.getValue()) != blockNumber) {
            // empty if block
        }
    }

    private ReadResponse.SubChoice varParamAccess(VariableAccessSpecification varAccessSpec) {
        ParameterizedAccess parameterizedAccess = varAccessSpec.parameterizedAccess;
        int variableName = (int)parameterizedAccess.variableName.getValue() & 0xFFFF;
        return this.access(variableName, parameterizedAccess);
    }

    private ReadResponse.SubChoice access(int variableName, ParameterizedAccess parameterizedAccess) {
        ReadResponse.SubChoice res = new ReadResponse.SubChoice();
        try {
            DataObject resDo = this.requestProcessorData.getDirectory().snGetOrInvoke(this.logicalDeviceId(), variableName, parameterizedAccess, this.connectionId());
            res.setData(DataConverter.convertDataObjectToData(resDo));
        }
        catch (IllegalAttributeAccessException e) {
            res.setDataAccessError(DlmsEnumFunctions.enumToAxdrEnum(e.getAccessResultCode()));
        }
        catch (IllegalMethodAccessException e) {
            res.setDataAccessError(DlmsEnumFunctions.enumToAxdrEnum(e.getMethodResultCode()));
        }
        return res;
    }

    private ReadResponse.SubChoice varNameAccess(VariableAccessSpecification varAccessSpec) {
        int variableName = (int)varAccessSpec.variableName.getValue() & 0xFFFF;
        ParameterizedAccess parameterizedAccess = null;
        return this.access(variableName, parameterizedAccess);
    }
}

