/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.association.ln;

import java.io.IOException;
import java.util.Iterator;
import org.openmuc.jdlms.AccessResultCode;
import org.openmuc.jdlms.AttributeAddress;
import org.openmuc.jdlms.ObisCode;
import org.openmuc.jdlms.SelectiveAccessDescription;
import org.openmuc.jdlms.SetParameter;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.APdu;
import org.openmuc.jdlms.internal.DataConverter;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOptional;
import org.openmuc.jdlms.internal.asn1.cosem.COSEMpdu;
import org.openmuc.jdlms.internal.asn1.cosem.CosemAttributeDescriptor;
import org.openmuc.jdlms.internal.asn1.cosem.CosemAttributeDescriptorWithSelection;
import org.openmuc.jdlms.internal.asn1.cosem.Data;
import org.openmuc.jdlms.internal.asn1.cosem.InvokeIdAndPriority;
import org.openmuc.jdlms.internal.asn1.cosem.SelectiveAccessDescriptor;
import org.openmuc.jdlms.internal.asn1.cosem.SetRequest;
import org.openmuc.jdlms.internal.asn1.cosem.SetRequestNormal;
import org.openmuc.jdlms.internal.asn1.cosem.SetRequestWithList;
import org.openmuc.jdlms.internal.asn1.cosem.SetResponse;
import org.openmuc.jdlms.internal.asn1.cosem.SetResponseNormal;
import org.openmuc.jdlms.internal.asn1.cosem.SetResponseWithList;
import org.openmuc.jdlms.internal.association.AssociationMessenger;
import org.openmuc.jdlms.internal.association.RequestProcessorBase;
import org.openmuc.jdlms.internal.association.RequestProcessorData;

public class SetRequestProcessor
extends RequestProcessorBase {
    public SetRequestProcessor(AssociationMessenger associationMessenger, RequestProcessorData requestProcessorData) {
        super(associationMessenger, requestProcessorData);
    }

    @Override
    public void processRequest(COSEMpdu request) throws IOException {
        SetResponse setResponse;
        SetRequest setRequest = request.setRequest;
        switch (setRequest.getChoiceIndex()) {
            case SET_REQUEST_NORMAL: {
                setResponse = this.processSetRequestNormal(setRequest.setRequestNormal);
                break;
            }
            case SET_REQUEST_WITH_LIST: {
                setResponse = this.processSetRequestWithList(setRequest.setRequestWithList);
                break;
            }
            default: {
                throw new IOException("Not yet implemented");
            }
        }
        COSEMpdu cosemPdu = new COSEMpdu();
        cosemPdu.setSetResponse(setResponse);
        APdu aPdu = new APdu(null, cosemPdu);
        this.associationMessenger.encodeAndSend(aPdu);
    }

    private SetResponse processSetRequestWithList(SetRequestWithList requestWithList) {
        InvokeIdAndPriority invokeIdAndPriority = requestWithList.invokeIdAndPriority;
        Iterator descriptorListIter = requestWithList.attributeDescriptorList.list().iterator();
        Iterator valueListIter = requestWithList.valueList.list().iterator();
        SetResponseWithList.SubSeqOfResult result = new SetResponseWithList.SubSeqOfResult();
        while (descriptorListIter.hasNext() && valueListIter.hasNext()) {
            CosemAttributeDescriptorWithSelection descriptor = (CosemAttributeDescriptorWithSelection)descriptorListIter.next();
            AccessResultCode resultCode = this.convertAndSet((Data)valueListIter.next(), descriptor.cosemAttributeDescriptor, descriptor.accessSelection);
            result.add(new AxdrEnum(resultCode.getCode()));
        }
        SetResponse setResponse = new SetResponse();
        SetResponseWithList responseWithList = new SetResponseWithList(invokeIdAndPriority, result);
        setResponse.setSetResponseWithList(responseWithList);
        return setResponse;
    }

    private SetResponse processSetRequestNormal(SetRequestNormal normalRequest) {
        InvokeIdAndPriority invokeIdAndPriority = normalRequest.invokeIdAndPriority;
        AccessResultCode accessResultCode = this.convertAndSet(normalRequest.value, normalRequest.cosemAttributeDescriptor, normalRequest.accessSelection);
        SetResponseNormal setResponseNormal = new SetResponseNormal(invokeIdAndPriority, new AxdrEnum(accessResultCode.getCode()));
        SetResponse setResponse = new SetResponse();
        setResponse.setSetResponseNormal(setResponseNormal);
        return setResponse;
    }

    private AccessResultCode convertAndSet(Data newValue, CosemAttributeDescriptor cosemAttributeAescriptor, AxdrOptional<SelectiveAccessDescriptor> accessSelection) {
        DataObject dataObject = DataConverter.convertDataToDataObject(newValue);
        ObisCode instanceId = new ObisCode(cosemAttributeAescriptor.instanceId.getValue());
        SelectiveAccessDescription selectiveAccessDescription = null;
        if (accessSelection.isUsed()) {
            SelectiveAccessDescriptor accessDescriptor = accessSelection.getValue();
            int accessSelector = (int)accessDescriptor.accessSelector.getValue();
            DataObject accessParameter = DataConverter.convertDataToDataObject(accessDescriptor.accessParameters);
            selectiveAccessDescription = new SelectiveAccessDescription(accessSelector, accessParameter);
        }
        int classId = (int)cosemAttributeAescriptor.classId.getValue();
        int attributeId = (int)cosemAttributeAescriptor.attributeId.getValue();
        AttributeAddress attributeAddress = new AttributeAddress(classId, instanceId, attributeId, selectiveAccessDescription);
        SetParameter setParam = new SetParameter(attributeAddress, dataObject);
        return this.requestProcessorData.getDirectory().set(this.requestProcessorData.logicalDeviceId, setParam, this.connectionId());
    }
}

