/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.association.ln;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.ByteArrayInputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.List;
import org.openmuc.jdlms.AttributeAddress;
import org.openmuc.jdlms.IllegalAttributeAccessException;
import org.openmuc.jdlms.ObisCode;
import org.openmuc.jdlms.SelectiveAccessDescription;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.APdu;
import org.openmuc.jdlms.internal.DataConverter;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrBoolean;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOctetString;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOptional;
import org.openmuc.jdlms.internal.asn1.cosem.COSEMpdu;
import org.openmuc.jdlms.internal.asn1.cosem.CosemAttributeDescriptor;
import org.openmuc.jdlms.internal.asn1.cosem.CosemAttributeDescriptorWithSelection;
import org.openmuc.jdlms.internal.asn1.cosem.Data;
import org.openmuc.jdlms.internal.asn1.cosem.DataBlockG;
import org.openmuc.jdlms.internal.asn1.cosem.GetDataResult;
import org.openmuc.jdlms.internal.asn1.cosem.GetRequest;
import org.openmuc.jdlms.internal.asn1.cosem.GetRequestNext;
import org.openmuc.jdlms.internal.asn1.cosem.GetRequestNormal;
import org.openmuc.jdlms.internal.asn1.cosem.GetRequestWithList;
import org.openmuc.jdlms.internal.asn1.cosem.GetResponse;
import org.openmuc.jdlms.internal.asn1.cosem.GetResponseNormal;
import org.openmuc.jdlms.internal.asn1.cosem.GetResponseWithDatablock;
import org.openmuc.jdlms.internal.asn1.cosem.GetResponseWithList;
import org.openmuc.jdlms.internal.asn1.cosem.InvokeIdAndPriority;
import org.openmuc.jdlms.internal.asn1.cosem.SelectiveAccessDescriptor;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned32;
import org.openmuc.jdlms.internal.asn1.iso.acse.ACSEApdu;
import org.openmuc.jdlms.internal.association.AssociationMessenger;
import org.openmuc.jdlms.internal.association.RequestProcessorBase;
import org.openmuc.jdlms.internal.association.RequestProcessorData;

public class GetRequestProcessor
extends RequestProcessorBase {
    private static final int OVERHEAD = 35;

    public GetRequestProcessor(AssociationMessenger associationMessenger, RequestProcessorData requestProcessorData) {
        super(associationMessenger, requestProcessorData);
    }

    @Override
    public void processRequest(COSEMpdu request) throws IOException {
        int clientMaxReceivePduSize = this.associationMessenger.getMaxMessageLength();
        GetRequest getRequest = request.getRequest;
        InvokeIdAndPriority invokeIdPrio = null;
        byte[] bytesToSend = null;
        switch (getRequest.getChoiceIndex()) {
            case GET_REQUEST_NORMAL: {
                invokeIdPrio = getRequest.getRequestNormal.invokeIdAndPriority;
                GetResponse getResponse = this.processGetRequestNormal(getRequest.getRequestNormal, invokeIdPrio);
                bytesToSend = this.encodeData(getResponse);
                this.encodeAndSend(clientMaxReceivePduSize, getResponse, invokeIdPrio, bytesToSend, getResponse.getResponseNormal.result.data);
                break;
            }
            case GET_REQUEST_WITH_LIST: {
                invokeIdPrio = getRequest.getRequestWithList.invokeIdAndPriority;
                GetResponse getResponse = this.processGetRequestWithList(getRequest.getRequestWithList, invokeIdPrio);
                bytesToSend = this.encodeData(getResponse);
                this.encodeAndSend(clientMaxReceivePduSize, getResponse, invokeIdPrio, bytesToSend, getResponse.getResponseWithList.result);
                break;
            }
            default: {
                throw new IOException();
            }
        }
    }

    private void encodeAndSend(long clientMaxReceivePduSize, GetResponse getResponse, InvokeIdAndPriority invokeIdPrio, byte[] bytesToSend, AxdrType axdrData) throws IOException {
        if (clientMaxReceivePduSize != 0L && (long)bytesToSend.length > clientMaxReceivePduSize) {
            this.sendAsDataBlocks(clientMaxReceivePduSize, getResponse, invokeIdPrio, axdrData, bytesToSend.length);
        } else {
            this.associationMessenger.send(bytesToSend);
        }
    }

    private void sendAsDataBlocks(long clientMaxReceivePduSize, GetResponse getResponse, InvokeIdAndPriority invokeIdPrio, AxdrType data, int size) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(size);
        data.encode(axdrOStream);
        byte[] completeBlock = axdrOStream.getArray();
        int blockSize = (int)clientMaxReceivePduSize - 35;
        byte[] block = new byte[blockSize];
        long blockNumber = 1L;
        try (DataInputStream ds = new DataInputStream(new ByteArrayInputStream(completeBlock));){
            while (true) {
                boolean resposneNumEquals;
                if (blockSize > ds.available()) {
                    block = new byte[ds.available()];
                }
                ds.readFully(block);
                boolean lastBlock = ds.available() == 0;
                DataBlockG.SubChoiceResult result = new DataBlockG.SubChoiceResult();
                result.setRawData(new AxdrOctetString(block));
                DataBlockG dataBlockG = new DataBlockG(new AxdrBoolean(lastBlock), new Unsigned32(blockNumber++), result);
                GetResponseWithDatablock gdata = new GetResponseWithDatablock(invokeIdPrio, dataBlockG);
                getResponse.setGetResponseWithDatablock(gdata);
                ACSEApdu acseAPdu = null;
                COSEMpdu coseMpdu = new COSEMpdu();
                coseMpdu.setGetResponse(getResponse);
                APdu blockApdu = new APdu(acseAPdu, coseMpdu);
                this.associationMessenger.encodeAndSend(blockApdu);
                if (lastBlock) {
                    break;
                }
                APdu nextApdu = this.associationMessenger.readNextApdu();
                if (!GetRequestProcessor.isGetNext(nextApdu)) {
                    throw new IllegalStateException();
                }
                GetRequestNext nextGetRequest = nextApdu.getCosemPdu().getRequest.getRequestNext;
                boolean bl = resposneNumEquals = nextGetRequest.blockNumber.getValue() == blockNumber - 1L;
                if (!resposneNumEquals) {
                    throw new IllegalStateException();
                }
                invokeIdPrio = nextGetRequest.invokeIdAndPriority;
            }
        }
    }

    private byte[] encodeData(GetResponse getResponse) throws IOException {
        COSEMpdu coseMpdu = new COSEMpdu();
        coseMpdu.setGetResponse(getResponse);
        APdu aPdu = new APdu(null, coseMpdu);
        return this.associationMessenger.encode(aPdu);
    }

    private static boolean isGetNext(APdu nextApdu) {
        return nextApdu.getCosemPdu().getChoiceIndex() == COSEMpdu.Choices.GET_REQUEST && nextApdu.getCosemPdu().getRequest.getChoiceIndex() == GetRequest.Choices.GET_REQUEST_NEXT;
    }

    private GetResponse processGetRequestWithList(GetRequestWithList requestWithList, InvokeIdAndPriority invokeIdPrio) {
        List list = requestWithList.attributeDescriptorList.list();
        GetResponseWithList.SubSeqOfResult result = new GetResponseWithList.SubSeqOfResult();
        for (CosemAttributeDescriptorWithSelection attributeDescriptor : list) {
            GetDataResult element = this.tryGet(attributeDescriptor.cosemAttributeDescriptor, attributeDescriptor.accessSelection);
            result.add(element);
        }
        GetResponse getResponse = new GetResponse();
        GetResponseWithList responseWithList = new GetResponseWithList(invokeIdPrio, result);
        getResponse.setGetResponseWithList(responseWithList);
        return getResponse;
    }

    private GetResponse processGetRequestNormal(GetRequestNormal normalRequest, InvokeIdAndPriority invokeIdAndPriority) {
        GetDataResult result = this.tryGet(normalRequest.cosemAttributeDescriptor, normalRequest.accessSelection);
        GetResponse getResponse = new GetResponse();
        getResponse.setGetResponseNormal(new GetResponseNormal(invokeIdAndPriority, result));
        return getResponse;
    }

    private GetDataResult tryGet(CosemAttributeDescriptor cosemAttributeDescriptor, AxdrOptional<SelectiveAccessDescriptor> accessSelection) {
        GetDataResult result = new GetDataResult();
        try {
            ObisCode instanceId = new ObisCode(cosemAttributeDescriptor.instanceId.getValue());
            SelectiveAccessDescription selectiveAccessDescription = null;
            if (accessSelection.isUsed()) {
                SelectiveAccessDescriptor accessDescriptor = accessSelection.getValue();
                int accessSelector = (int)accessDescriptor.accessSelector.getValue();
                DataObject accessParameter = DataConverter.convertDataToDataObject(accessDescriptor.accessParameters);
                selectiveAccessDescription = new SelectiveAccessDescription(accessSelector, accessParameter);
            }
            int logicalDeviceId = this.requestProcessorData.logicalDeviceId;
            long classId = cosemAttributeDescriptor.classId.getValue();
            long attributeId = cosemAttributeDescriptor.attributeId.getValue();
            AttributeAddress attributeAddress = new AttributeAddress((int)classId, instanceId, (int)attributeId, selectiveAccessDescription);
            DataObject attributeData = this.requestProcessorData.getDirectory().get(logicalDeviceId, attributeAddress, this.connectionId());
            Data convertedData = DataConverter.convertDataObjectToData(attributeData);
            result.setData(convertedData);
        }
        catch (IllegalAttributeAccessException e) {
            result.setDataAccessResult(new AxdrEnum(e.getAccessResultCode().getCode()));
        }
        return result;
    }
}

