/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.association.ln;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.util.Iterator;
import org.openmuc.jdlms.IllegalMethodAccessException;
import org.openmuc.jdlms.MethodParameter;
import org.openmuc.jdlms.MethodResultCode;
import org.openmuc.jdlms.ObisCode;
import org.openmuc.jdlms.datatypes.DataObject;
import org.openmuc.jdlms.internal.APdu;
import org.openmuc.jdlms.internal.DataConverter;
import org.openmuc.jdlms.internal.MessageFragment;
import org.openmuc.jdlms.internal.PduHelper;
import org.openmuc.jdlms.internal.ServiceError;
import org.openmuc.jdlms.internal.StateError;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrBoolean;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOctetString;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOptional;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequest;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequestNextPblock;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequestNormal;
import org.openmuc.jdlms.internal.asn1.cosem.ActionRequestWithList;
import org.openmuc.jdlms.internal.asn1.cosem.ActionResponse;
import org.openmuc.jdlms.internal.asn1.cosem.ActionResponseNormal;
import org.openmuc.jdlms.internal.asn1.cosem.ActionResponseWithList;
import org.openmuc.jdlms.internal.asn1.cosem.ActionResponseWithOptionalData;
import org.openmuc.jdlms.internal.asn1.cosem.ActionResponseWithPblock;
import org.openmuc.jdlms.internal.asn1.cosem.COSEMpdu;
import org.openmuc.jdlms.internal.asn1.cosem.CosemMethodDescriptor;
import org.openmuc.jdlms.internal.asn1.cosem.Data;
import org.openmuc.jdlms.internal.asn1.cosem.DataBlockSA;
import org.openmuc.jdlms.internal.asn1.cosem.GetDataResult;
import org.openmuc.jdlms.internal.asn1.cosem.InvokeIdAndPriority;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned32;
import org.openmuc.jdlms.internal.association.AssociationException;
import org.openmuc.jdlms.internal.association.AssociationMessenger;
import org.openmuc.jdlms.internal.association.RequestProcessorBase;
import org.openmuc.jdlms.internal.association.RequestProcessorData;

public class ActionRequestProcessor
extends RequestProcessorBase {
    private static final ObisCode ASSOCIATION_LN_INSTANCE_ID = new ObisCode("0.0.40.0.0.255");

    public ActionRequestProcessor(AssociationMessenger associationMessenger, RequestProcessorData requestProcessorData) {
        super(associationMessenger, requestProcessorData);
    }

    @Override
    public void processRequest(COSEMpdu request) throws IOException {
        ActionRequest actionRequest = request.actionRequest;
        switch (actionRequest.getChoiceIndex()) {
            case ACTION_REQUEST_NORMAL: {
                this.processActionRequestNormal(actionRequest.actionRequestNormal);
                break;
            }
            case ACTION_REQUEST_WITH_LIST: {
                this.processActionRequestWithList(actionRequest.actionRequestWithList);
                break;
            }
            default: {
                throw new IOException("Not yet implemented");
            }
        }
    }

    private ActionResponseWithOptionalData invokeMethod(CosemMethodDescriptor methodDescriptor, DataObject param) throws AssociationException {
        GetDataResult getDataResult = new GetDataResult();
        ObisCode instanceId = new ObisCode(methodDescriptor.instanceId.getValue());
        long classId = methodDescriptor.classId.getValue();
        long methodId = methodDescriptor.methodId.getValue();
        if (!(this.requestProcessorData.connectionData.isAuthenticated() || ASSOCIATION_LN_INSTANCE_ID.equals(instanceId) && classId == 15L && methodId == 1L)) {
            throw new AssociationException(StateError.SERVICE_NOT_ALLOWED, ServiceError.OPERATION_NOT_POSSIBLE);
        }
        DataObject result = null;
        MethodResultCode resultCode = MethodResultCode.SUCCESS;
        try {
            MethodParameter methodParameter = new MethodParameter((int)classId, instanceId, (int)methodId, param);
            result = this.requestProcessorData.getDirectory().invokeMethod(this.requestProcessorData.logicalDeviceId, methodParameter, this.connectionId());
        }
        catch (IllegalMethodAccessException e) {
            resultCode = e.getMethodResultCode();
            getDataResult = null;
        }
        if (result != null) {
            getDataResult.setData(DataConverter.convertDataObjectToData(result));
        } else {
            getDataResult = null;
        }
        return new ActionResponseWithOptionalData(new AxdrEnum(resultCode.getCode()), getDataResult);
    }

    private void processActionRequestNormal(ActionRequestNormal normalRequest) throws IOException {
        InvokeIdAndPriority invokeIdAndPriority = normalRequest.invokeIdAndPriority;
        CosemMethodDescriptor cosemMethodDescriptor = normalRequest.cosemMethodDescriptor;
        AxdrOptional<Data> methodInvocationParameters = normalRequest.methodInvocationParameters;
        DataObject param = methodInvocationParameters.isUsed() ? DataConverter.convertDataToDataObject(methodInvocationParameters.getValue()) : null;
        ActionResponseWithOptionalData singleResult = this.invokeMethod(cosemMethodDescriptor, param);
        ActionResponse actionResponse = new ActionResponse();
        ActionResponseNormal normalResponse = new ActionResponseNormal(invokeIdAndPriority, singleResult);
        actionResponse.setActionResponseNormal(normalResponse);
        if (!this.associationMessenger.pduSizeTooLarge(actionResponse)) {
            this.sendActionResponse(actionResponse);
            return;
        }
        byte[] rawData = ActionRequestProcessor.encodePduRawDataBlockData(singleResult);
        this.sendActionResponseAsFragments(invokeIdAndPriority, rawData);
    }

    private void sendActionResponseAsFragments(InvokeIdAndPriority invokeIdAndPriority, byte[] rawData) throws IOException {
        ActionResponse actionResponse = new ActionResponse();
        int fragmentSize = (int)this.requestProcessorData.connectionData.getClientMaxReceivePduSize() - 10;
        MessageFragment messageFragment = new MessageFragment(rawData, fragmentSize);
        long blockNumber = 1L;
        boolean lastBlock = false;
        byte[] octetString = messageFragment.next();
        DataBlockSA pblock = ActionRequestProcessor.pBlockFrom(blockNumber, lastBlock, octetString);
        ActionResponseWithPblock responseWithPblock = new ActionResponseWithPblock(invokeIdAndPriority, pblock);
        actionResponse.setActionResponseWithPblock(responseWithPblock);
        this.sendActionResponse(actionResponse);
        while (messageFragment.hasNext()) {
            COSEMpdu cosemPdu = this.associationMessenger.readNextApdu().getCosemPdu();
            if (cosemPdu.getChoiceIndex() != COSEMpdu.Choices.ACTION_REQUEST) {
                throw new IOException("wrong request type.");
            }
            ActionRequest actionRequest = cosemPdu.actionRequest;
            if (actionRequest.getChoiceIndex() != ActionRequest.Choices.ACTION_REQUEST_NEXT_PBLOCK) {
                throw new IOException("Wrong action type.");
            }
            ActionRequestNextPblock requestNextPblock = actionRequest.actionRequestNextPblock;
            InvokeIdAndPriority invokeIdAndPriorityRpl = requestNextPblock.invokeIdAndPriority;
            if (PduHelper.invokeIdFrom(invokeIdAndPriorityRpl) != PduHelper.invokeIdFrom(invokeIdAndPriority)) {
                throw new IOException("Wrong invoke id");
            }
            if (blockNumber++ != requestNextPblock.blockNumber.getValue()) {
                throw new IOException("Wrong pblock confimation.");
            }
            pblock = ActionRequestProcessor.pBlockFrom(blockNumber, !messageFragment.hasNext(), messageFragment.next());
            responseWithPblock = new ActionResponseWithPblock(invokeIdAndPriority, pblock);
            actionResponse.setActionResponseWithPblock(responseWithPblock);
            this.sendActionResponse(actionResponse);
        }
    }

    private void processActionRequestWithList(ActionRequestWithList requestWithList) throws IOException {
        InvokeIdAndPriority invokeIdAndPriority = requestWithList.invokeIdAndPriority;
        Iterator invocationParametersIter = requestWithList.methodInvocationParameters.list().iterator();
        Iterator methodDescriptorIter = requestWithList.cosemMethodDescriptorList.list().iterator();
        ActionResponseWithList.SubSeqOfListOfResponses listOfResponses = new ActionResponseWithList.SubSeqOfListOfResponses();
        while (invocationParametersIter.hasNext() && methodDescriptorIter.hasNext()) {
            Data invokationParameter = (Data)invocationParametersIter.next();
            CosemMethodDescriptor methodDescriptor = (CosemMethodDescriptor)methodDescriptorIter.next();
            DataObject param = DataConverter.convertDataToDataObject(invokationParameter);
            if (param.isNull()) {
                param = null;
            }
            ActionResponseWithOptionalData actionResult = this.invokeMethod(methodDescriptor, param);
            listOfResponses.add(actionResult);
        }
        ActionResponseWithList responseWithList = new ActionResponseWithList(invokeIdAndPriority, listOfResponses);
        ActionResponse actionResponse = new ActionResponse();
        actionResponse.setActionResponseWithList(responseWithList);
        if (!this.associationMessenger.pduSizeTooLarge(actionResponse)) {
            this.sendActionResponse(actionResponse);
            return;
        }
        byte[] rawData = ActionRequestProcessor.encodePduRawDataBlockData(listOfResponses);
        this.sendActionResponseAsFragments(invokeIdAndPriority, rawData);
    }

    private static byte[] encodePduRawDataBlockData(AxdrType axdrType) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(65535);
        axdrType.encode(axdrOStream);
        return axdrOStream.getArray();
    }

    private static DataBlockSA pBlockFrom(long blockNumber, boolean lastBlock, byte[] octetString) {
        AxdrBoolean lastBlockAxdr = new AxdrBoolean(lastBlock);
        Unsigned32 blockNumberU32 = new Unsigned32(blockNumber);
        AxdrOctetString rawData = new AxdrOctetString(octetString);
        return new DataBlockSA(lastBlockAxdr, blockNumberU32, rawData);
    }

    private void sendActionResponse(ActionResponse actionResponse) throws IOException {
        COSEMpdu cosemPdu = new COSEMpdu();
        cosemPdu.setActionResponse(actionResponse);
        APdu aPdu = new APdu(null, cosemPdu);
        this.associationMessenger.encodeAndSend(aPdu);
    }
}

