/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.association;

import java.io.IOException;
import java.util.Arrays;
import org.openmuc.jdlms.SecuritySuite;
import org.openmuc.jdlms.internal.APdu;
import org.openmuc.jdlms.internal.DataDirectoryImpl;
import org.openmuc.jdlms.internal.ServerConnectionData;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.NullOutputStream;

public class AssociationMessenger {
    private final ServerConnectionData connectionData;
    private final DataDirectoryImpl directory;
    private SecuritySuite securitySuite;
    private final byte[] buffer = new byte[0x4FFFFB];

    public AssociationMessenger(ServerConnectionData connectionData, DataDirectoryImpl directory) {
        this.connectionData = connectionData;
        this.directory = directory;
    }

    public void encodeAndSend(APdu aPdu) throws IOException {
        this.send(this.encode(aPdu));
    }

    public void send(byte[] data) throws IOException {
        this.connectionData.getSessionLayer().send(data);
    }

    public APdu readNextApdu() throws IOException {
        byte[] bytes = this.connectionData.getSessionLayer().readNextMessage();
        APdu apdu = APdu.decode(bytes, null);
        SecuritySuite sec = this.connectionData.getSecuritySuite();
        if (sec.getEncryptionMechanism() == SecuritySuite.EncryptionMechanism.NONE) {
            return apdu;
        }
        if (apdu.getCosemPdu() == null || !apdu.isEncrypted()) {
            // empty if block
        }
        if (this.connectionData.getClientSystemTitle() == null) {
            this.connectionData.setClientSystemTitle(this.systemTitle());
        }
        this.securitySuite = SecuritySuite.newSecuritySuiteFrom(sec);
        return APdu.decode(bytes, this.connectionData.getClientSystemTitle(), sec, null);
    }

    public synchronized byte[] encode(APdu aPdu) throws IOException {
        int length;
        SecuritySuite sec = this.connectionData.getSecuritySuite();
        if (sec.getEncryptionMechanism() != SecuritySuite.EncryptionMechanism.NONE) {
            if (this.securitySuite == null) {
                this.securitySuite = SecuritySuite.newSecuritySuiteFrom(sec);
            }
            length = aPdu.encode(this.buffer, this.connectionData.getAndIncrementFc(), this.systemTitle(), this.securitySuite, null);
        } else {
            length = aPdu.encode(this.buffer, null);
        }
        return Arrays.copyOfRange(this.buffer, this.buffer.length - length, this.buffer.length);
    }

    public byte[] systemTitle() {
        return this.directory.getLogicalDeviceFor(this.connectionData.getSessionLayer().getLogicalDeviceId()).getLogicalDevice().getSystemTitle();
    }

    public boolean pduSizeTooLarge(AxdrType actionResponse) throws IOException {
        int maxMessageLength = this.getMaxMessageLength();
        return maxMessageLength != 0 && AssociationMessenger.pduSizeOf(actionResponse) >= maxMessageLength;
    }

    public int getMaxMessageLength() {
        if ((int)this.connectionData.getClientMaxReceivePduSize() == 0) {
            return 65535;
        }
        return (int)this.connectionData.getClientMaxReceivePduSize();
    }

    public boolean apduTooLarge(int apduSize) {
        int maxMessageLength = this.getMaxMessageLength();
        return maxMessageLength != 0 && apduSize >= maxMessageLength;
    }

    public static int pduSizeOf(AxdrType pdu) throws IOException {
        return pdu.encode(new NullOutputStream());
    }
}

