/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.iso.acse;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.openmuc.jdlms.internal.asn1.iso.acse.AssociationInformation;
import org.openmuc.jdlms.internal.asn1.iso.acse.ReleaseResponseReason;

public class RLREApdu
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final BerTag tag = new BerTag(64, 32, 3);
    private byte[] code = null;
    private ReleaseResponseReason reason = null;
    private AssociationInformation userInformation = null;

    public RLREApdu() {
    }

    public RLREApdu(byte[] code) {
        this.code = code;
    }

    public void setReason(ReleaseResponseReason reason) {
        this.reason = reason;
    }

    public ReleaseResponseReason getReason() {
        return this.reason;
    }

    public void setUserInformation(AssociationInformation userInformation) {
        this.userInformation = userInformation;
    }

    public AssociationInformation getUserInformation() {
        return this.userInformation;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.userInformation != null) {
            int sublength = this.userInformation.encode(reverseOS, true);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(190);
            ++codeLength;
        }
        if (this.reason != null) {
            codeLength += this.reason.encode(reverseOS, false);
            reverseOS.write(128);
            ++codeLength;
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        if (lengthVal == 0) {
            return tlByteCount;
        }
        vByteCount += berTag.decode(is);
        if (berTag.equals(128, 0, 0)) {
            this.reason = new ReleaseResponseReason();
            if (lengthVal >= 0 && (vByteCount += this.reason.decode(is, false)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (berTag.equals(128, 32, 30)) {
            vByteCount += length.decode(is);
            this.userInformation = new AssociationInformation();
            vByteCount += this.userInformation.decode(is, true);
            if (lengthVal >= 0 && (vByteCount += length.readEocIfIndefinite(is)) == lengthVal) {
                return tlByteCount + vByteCount;
            }
            vByteCount += berTag.decode(is);
        }
        if (lengthVal < 0) {
            if (!berTag.equals(0, 0, 0)) {
                throw new IOException("Decoded sequence has wrong end of contents octets");
            }
            return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
        }
        throw new IOException("Unexpected end of sequence, length tag: " + lengthVal + ", bytes decoded: " + vByteCount);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.reason != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("reason: ").append((Object)this.reason);
            firstSelectedElement = false;
        }
        if (this.userInformation != null) {
            if (!firstSelectedElement) {
                sb.append(",\n");
            }
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("userInformation: ").append((Object)this.userInformation);
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

