/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.iso.acse;

import com.beanit.asn1bean.ber.BerLength;
import com.beanit.asn1bean.ber.BerTag;
import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import com.beanit.asn1bean.ber.types.BerBitString;
import com.beanit.asn1bean.ber.types.BerObjectIdentifier;
import com.beanit.asn1bean.ber.types.BerType;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import org.openmuc.jdlms.internal.asn1.iso.acse.ACSERequirements;
import org.openmuc.jdlms.internal.asn1.iso.acse.AEInvocationIdentifier;
import org.openmuc.jdlms.internal.asn1.iso.acse.AEQualifier;
import org.openmuc.jdlms.internal.asn1.iso.acse.APInvocationIdentifier;
import org.openmuc.jdlms.internal.asn1.iso.acse.APTitle;
import org.openmuc.jdlms.internal.asn1.iso.acse.ApplicationContextNameList;
import org.openmuc.jdlms.internal.asn1.iso.acse.AssociateResult;
import org.openmuc.jdlms.internal.asn1.iso.acse.AssociateSourceDiagnostic;
import org.openmuc.jdlms.internal.asn1.iso.acse.AssociationInformation;
import org.openmuc.jdlms.internal.asn1.iso.acse.AuthenticationValue;
import org.openmuc.jdlms.internal.asn1.iso.acse.ImplementationData;
import org.openmuc.jdlms.internal.asn1.iso.acse.MechanismName;

public class AAREApdu
implements BerType,
Serializable {
    private static final long serialVersionUID = 1L;
    public static final BerTag tag = new BerTag(64, 32, 1);
    private byte[] code = null;
    private BerBitString protocolVersion = null;
    private BerObjectIdentifier applicationContextName = null;
    private AssociateResult result = null;
    private AssociateSourceDiagnostic resultSourceDiagnostic = null;
    private APTitle respondingAPTitle = null;
    private AEQualifier respondingAEQualifier = null;
    private APInvocationIdentifier respondingAPInvocationIdentifier = null;
    private AEInvocationIdentifier respondingAEInvocationIdentifier = null;
    private ACSERequirements responderAcseRequirements = null;
    private MechanismName mechanismName = null;
    private AuthenticationValue respondingAuthenticationValue = null;
    private ApplicationContextNameList applicationContextNameList = null;
    private ImplementationData implementationInformation = null;
    private AssociationInformation userInformation = null;

    public AAREApdu() {
    }

    public AAREApdu(byte[] code) {
        this.code = code;
    }

    public void setProtocolVersion(BerBitString protocolVersion) {
        this.protocolVersion = protocolVersion;
    }

    public BerBitString getProtocolVersion() {
        return this.protocolVersion;
    }

    public void setApplicationContextName(BerObjectIdentifier applicationContextName) {
        this.applicationContextName = applicationContextName;
    }

    public BerObjectIdentifier getApplicationContextName() {
        return this.applicationContextName;
    }

    public void setResult(AssociateResult result) {
        this.result = result;
    }

    public AssociateResult getResult() {
        return this.result;
    }

    public void setResultSourceDiagnostic(AssociateSourceDiagnostic resultSourceDiagnostic) {
        this.resultSourceDiagnostic = resultSourceDiagnostic;
    }

    public AssociateSourceDiagnostic getResultSourceDiagnostic() {
        return this.resultSourceDiagnostic;
    }

    public void setRespondingAPTitle(APTitle respondingAPTitle) {
        this.respondingAPTitle = respondingAPTitle;
    }

    public APTitle getRespondingAPTitle() {
        return this.respondingAPTitle;
    }

    public void setRespondingAEQualifier(AEQualifier respondingAEQualifier) {
        this.respondingAEQualifier = respondingAEQualifier;
    }

    public AEQualifier getRespondingAEQualifier() {
        return this.respondingAEQualifier;
    }

    public void setRespondingAPInvocationIdentifier(APInvocationIdentifier respondingAPInvocationIdentifier) {
        this.respondingAPInvocationIdentifier = respondingAPInvocationIdentifier;
    }

    public APInvocationIdentifier getRespondingAPInvocationIdentifier() {
        return this.respondingAPInvocationIdentifier;
    }

    public void setRespondingAEInvocationIdentifier(AEInvocationIdentifier respondingAEInvocationIdentifier) {
        this.respondingAEInvocationIdentifier = respondingAEInvocationIdentifier;
    }

    public AEInvocationIdentifier getRespondingAEInvocationIdentifier() {
        return this.respondingAEInvocationIdentifier;
    }

    public void setResponderAcseRequirements(ACSERequirements responderAcseRequirements) {
        this.responderAcseRequirements = responderAcseRequirements;
    }

    public ACSERequirements getResponderAcseRequirements() {
        return this.responderAcseRequirements;
    }

    public void setMechanismName(MechanismName mechanismName) {
        this.mechanismName = mechanismName;
    }

    public MechanismName getMechanismName() {
        return this.mechanismName;
    }

    public void setRespondingAuthenticationValue(AuthenticationValue respondingAuthenticationValue) {
        this.respondingAuthenticationValue = respondingAuthenticationValue;
    }

    public AuthenticationValue getRespondingAuthenticationValue() {
        return this.respondingAuthenticationValue;
    }

    public void setApplicationContextNameList(ApplicationContextNameList applicationContextNameList) {
        this.applicationContextNameList = applicationContextNameList;
    }

    public ApplicationContextNameList getApplicationContextNameList() {
        return this.applicationContextNameList;
    }

    public void setImplementationInformation(ImplementationData implementationInformation) {
        this.implementationInformation = implementationInformation;
    }

    public ImplementationData getImplementationInformation() {
        return this.implementationInformation;
    }

    public void setUserInformation(AssociationInformation userInformation) {
        this.userInformation = userInformation;
    }

    public AssociationInformation getUserInformation() {
        return this.userInformation;
    }

    public int encode(OutputStream reverseOS) throws IOException {
        return this.encode(reverseOS, true);
    }

    public int encode(OutputStream reverseOS, boolean withTag) throws IOException {
        int sublength;
        if (this.code != null) {
            reverseOS.write(this.code);
            if (withTag) {
                return tag.encode(reverseOS) + this.code.length;
            }
            return this.code.length;
        }
        int codeLength = 0;
        if (this.userInformation != null) {
            sublength = this.userInformation.encode(reverseOS, true);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(190);
            ++codeLength;
        }
        if (this.implementationInformation != null) {
            codeLength += this.implementationInformation.encode(reverseOS, false);
            reverseOS.write(157);
            ++codeLength;
        }
        if (this.applicationContextNameList != null) {
            codeLength += this.applicationContextNameList.encode(reverseOS, false);
            reverseOS.write(171);
            ++codeLength;
        }
        if (this.respondingAuthenticationValue != null) {
            sublength = this.respondingAuthenticationValue.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(170);
            ++codeLength;
        }
        if (this.mechanismName != null) {
            codeLength += this.mechanismName.encode(reverseOS, false);
            reverseOS.write(137);
            ++codeLength;
        }
        if (this.responderAcseRequirements != null) {
            codeLength += this.responderAcseRequirements.encode(reverseOS, false);
            reverseOS.write(136);
            ++codeLength;
        }
        if (this.respondingAEInvocationIdentifier != null) {
            sublength = this.respondingAEInvocationIdentifier.encode(reverseOS, true);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(167);
            ++codeLength;
        }
        if (this.respondingAPInvocationIdentifier != null) {
            sublength = this.respondingAPInvocationIdentifier.encode(reverseOS, true);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(166);
            ++codeLength;
        }
        if (this.respondingAEQualifier != null) {
            sublength = this.respondingAEQualifier.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(165);
            ++codeLength;
        }
        if (this.respondingAPTitle != null) {
            sublength = this.respondingAPTitle.encode(reverseOS);
            codeLength += sublength;
            codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
            reverseOS.write(164);
            ++codeLength;
        }
        sublength = this.resultSourceDiagnostic.encode(reverseOS);
        codeLength += sublength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
        reverseOS.write(163);
        ++codeLength;
        sublength = this.result.encode(reverseOS, true);
        codeLength += sublength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
        reverseOS.write(162);
        ++codeLength;
        sublength = this.applicationContextName.encode(reverseOS, true);
        codeLength += sublength;
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)sublength);
        reverseOS.write(161);
        ++codeLength;
        if (this.protocolVersion != null) {
            codeLength += this.protocolVersion.encode(reverseOS, false);
            reverseOS.write(128);
            ++codeLength;
        }
        codeLength += BerLength.encodeLength((OutputStream)reverseOS, (int)codeLength);
        if (withTag) {
            codeLength += tag.encode(reverseOS);
        }
        return codeLength;
    }

    public int decode(InputStream is) throws IOException {
        return this.decode(is, true);
    }

    public int decode(InputStream is, boolean withTag) throws IOException {
        int tlByteCount = 0;
        int vByteCount = 0;
        BerTag berTag = new BerTag();
        if (withTag) {
            tlByteCount += tag.decodeAndCheck(is);
        }
        BerLength length = new BerLength();
        tlByteCount += length.decode(is);
        int lengthVal = length.val;
        while (vByteCount < lengthVal || lengthVal < 0) {
            vByteCount += berTag.decode(is);
            if (berTag.equals(128, 0, 0)) {
                this.protocolVersion = new BerBitString();
                vByteCount += this.protocolVersion.decode(is, false);
                continue;
            }
            if (berTag.equals(128, 32, 1)) {
                vByteCount += length.decode(is);
                this.applicationContextName = new BerObjectIdentifier();
                vByteCount += this.applicationContextName.decode(is, true);
                vByteCount += length.readEocIfIndefinite(is);
                continue;
            }
            if (berTag.equals(128, 32, 2)) {
                vByteCount += length.decode(is);
                this.result = new AssociateResult();
                vByteCount += this.result.decode(is, true);
                vByteCount += length.readEocIfIndefinite(is);
                continue;
            }
            if (berTag.equals(128, 32, 3)) {
                vByteCount += length.decode(is);
                this.resultSourceDiagnostic = new AssociateSourceDiagnostic();
                vByteCount += this.resultSourceDiagnostic.decode(is, null);
                vByteCount += length.readEocIfIndefinite(is);
                continue;
            }
            if (berTag.equals(128, 32, 4)) {
                vByteCount += length.decode(is);
                this.respondingAPTitle = new APTitle();
                vByteCount += this.respondingAPTitle.decode(is, null);
                vByteCount += length.readEocIfIndefinite(is);
                continue;
            }
            if (berTag.equals(128, 32, 5)) {
                vByteCount += length.decode(is);
                this.respondingAEQualifier = new AEQualifier();
                vByteCount += this.respondingAEQualifier.decode(is, null);
                vByteCount += length.readEocIfIndefinite(is);
                continue;
            }
            if (berTag.equals(128, 32, 6)) {
                vByteCount += length.decode(is);
                this.respondingAPInvocationIdentifier = new APInvocationIdentifier();
                vByteCount += this.respondingAPInvocationIdentifier.decode(is, true);
                vByteCount += length.readEocIfIndefinite(is);
                continue;
            }
            if (berTag.equals(128, 32, 7)) {
                vByteCount += length.decode(is);
                this.respondingAEInvocationIdentifier = new AEInvocationIdentifier();
                vByteCount += this.respondingAEInvocationIdentifier.decode(is, true);
                vByteCount += length.readEocIfIndefinite(is);
                continue;
            }
            if (berTag.equals(128, 0, 8)) {
                this.responderAcseRequirements = new ACSERequirements();
                vByteCount += this.responderAcseRequirements.decode(is, false);
                continue;
            }
            if (berTag.equals(128, 0, 9)) {
                this.mechanismName = new MechanismName();
                vByteCount += this.mechanismName.decode(is, false);
                continue;
            }
            if (berTag.equals(128, 32, 10)) {
                vByteCount += length.decode(is);
                this.respondingAuthenticationValue = new AuthenticationValue();
                vByteCount += this.respondingAuthenticationValue.decode(is, null);
                vByteCount += length.readEocIfIndefinite(is);
                continue;
            }
            if (berTag.equals(128, 32, 11)) {
                this.applicationContextNameList = new ApplicationContextNameList();
                vByteCount += this.applicationContextNameList.decode(is, false);
                continue;
            }
            if (berTag.equals(128, 0, 29)) {
                this.implementationInformation = new ImplementationData();
                vByteCount += this.implementationInformation.decode(is, false);
                continue;
            }
            if (berTag.equals(128, 32, 30)) {
                vByteCount += length.decode(is);
                this.userInformation = new AssociationInformation();
                vByteCount += this.userInformation.decode(is, true);
                vByteCount += length.readEocIfIndefinite(is);
                continue;
            }
            if (lengthVal < 0 && berTag.equals(0, 0, 0)) {
                return tlByteCount + (vByteCount += BerLength.readEocByte((InputStream)is));
            }
            throw new IOException("Tag does not match any set component: " + berTag);
        }
        if (vByteCount != lengthVal) {
            throw new IOException("Length of set does not match length tag, length tag: " + lengthVal + ", actual set length: " + vByteCount);
        }
        return tlByteCount + vByteCount;
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream reverseOS = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode((OutputStream)reverseOS, false);
        this.code = reverseOS.getArray();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.appendAsString(sb, 0);
        return sb.toString();
    }

    public void appendAsString(StringBuilder sb, int indentLevel) {
        int i;
        sb.append("{");
        boolean firstSelectedElement = true;
        if (this.protocolVersion != null) {
            sb.append("\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("protocolVersion: ").append(this.protocolVersion);
            firstSelectedElement = false;
        }
        if (!firstSelectedElement) {
            sb.append(",\n");
        }
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.applicationContextName != null) {
            sb.append("applicationContextName: ").append(this.applicationContextName);
        } else {
            sb.append("applicationContextName: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.result != null) {
            sb.append("result: ").append((Object)this.result);
        } else {
            sb.append("result: <empty-required-field>");
        }
        sb.append(",\n");
        for (i = 0; i < indentLevel + 1; ++i) {
            sb.append("\t");
        }
        if (this.resultSourceDiagnostic != null) {
            sb.append("resultSourceDiagnostic: ");
            this.resultSourceDiagnostic.appendAsString(sb, indentLevel + 1);
        } else {
            sb.append("resultSourceDiagnostic: <empty-required-field>");
        }
        if (this.respondingAPTitle != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("respondingAPTitle: ");
            this.respondingAPTitle.appendAsString(sb, indentLevel + 1);
        }
        if (this.respondingAEQualifier != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("respondingAEQualifier: ");
            this.respondingAEQualifier.appendAsString(sb, indentLevel + 1);
        }
        if (this.respondingAPInvocationIdentifier != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("respondingAPInvocationIdentifier: ").append((Object)this.respondingAPInvocationIdentifier);
        }
        if (this.respondingAEInvocationIdentifier != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("respondingAEInvocationIdentifier: ").append((Object)this.respondingAEInvocationIdentifier);
        }
        if (this.responderAcseRequirements != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("responderAcseRequirements: ").append((Object)this.responderAcseRequirements);
        }
        if (this.mechanismName != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("mechanismName: ").append((Object)this.mechanismName);
        }
        if (this.respondingAuthenticationValue != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("respondingAuthenticationValue: ");
            this.respondingAuthenticationValue.appendAsString(sb, indentLevel + 1);
        }
        if (this.applicationContextNameList != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("applicationContextNameList: ");
            this.applicationContextNameList.appendAsString(sb, indentLevel + 1);
        }
        if (this.implementationInformation != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("implementationInformation: ").append((Object)this.implementationInformation);
        }
        if (this.userInformation != null) {
            sb.append(",\n");
            for (i = 0; i < indentLevel + 1; ++i) {
                sb.append("\t");
            }
            sb.append("userInformation: ").append((Object)this.userInformation);
        }
        sb.append("\n");
        for (i = 0; i < indentLevel; ++i) {
            sb.append("\t");
        }
        sb.append("}");
    }
}

