/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.cosem.BlockNumberAccess;
import org.openmuc.jdlms.internal.asn1.cosem.Integer16;
import org.openmuc.jdlms.internal.asn1.cosem.ParameterizedAccess;
import org.openmuc.jdlms.internal.asn1.cosem.ReadDataBlockAccess;
import org.openmuc.jdlms.internal.asn1.cosem.WriteDataBlockAccess;

public class VariableAccessSpecification
implements AxdrType {
    public byte[] code = null;
    private Choices choice;
    public Integer16 variableName = null;
    public ParameterizedAccess parameterizedAccess = null;
    public BlockNumberAccess blockNumberAccess = null;
    public ReadDataBlockAccess readDataBlockAccess = null;
    public WriteDataBlockAccess writeDataBlockAccess = null;

    public VariableAccessSpecification() {
    }

    public VariableAccessSpecification(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
            return this.code.length;
        }
        if (this.choice == Choices._ERR_NONE_SELECTED) {
            throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
        }
        int codeLength = 0;
        if (this.choice == Choices.WRITE_DATA_BLOCK_ACCESS) {
            codeLength += this.writeDataBlockAccess.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(7L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.READ_DATA_BLOCK_ACCESS) {
            codeLength += this.readDataBlockAccess.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(6L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.BLOCK_NUMBER_ACCESS) {
            codeLength += this.blockNumberAccess.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(5L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.PARAMETERIZED_ACCESS) {
            codeLength += this.parameterizedAccess.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(4L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.VARIABLE_NAME) {
            codeLength += this.variableName.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(2L);
            return codeLength += c.encode(axdrOStream);
        }
        throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrEnum choosen = new AxdrEnum();
        codeLength += choosen.decode(iStream);
        this.resetChoices();
        this.choice = Choices.valueOf(choosen.getValue());
        if (this.choice == Choices.VARIABLE_NAME) {
            this.variableName = new Integer16();
            return codeLength += this.variableName.decode(iStream);
        }
        if (this.choice == Choices.PARAMETERIZED_ACCESS) {
            this.parameterizedAccess = new ParameterizedAccess();
            return codeLength += this.parameterizedAccess.decode(iStream);
        }
        if (this.choice == Choices.BLOCK_NUMBER_ACCESS) {
            this.blockNumberAccess = new BlockNumberAccess();
            return codeLength += this.blockNumberAccess.decode(iStream);
        }
        if (this.choice == Choices.READ_DATA_BLOCK_ACCESS) {
            this.readDataBlockAccess = new ReadDataBlockAccess();
            return codeLength += this.readDataBlockAccess.decode(iStream);
        }
        if (this.choice == Choices.WRITE_DATA_BLOCK_ACCESS) {
            this.writeDataBlockAccess = new WriteDataBlockAccess();
            return codeLength += this.writeDataBlockAccess.decode(iStream);
        }
        throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public Choices getChoiceIndex() {
        return this.choice;
    }

    public void setVariableName(Integer16 newVal) {
        this.resetChoices();
        this.choice = Choices.VARIABLE_NAME;
        this.variableName = newVal;
    }

    public void setParameterizedAccess(ParameterizedAccess newVal) {
        this.resetChoices();
        this.choice = Choices.PARAMETERIZED_ACCESS;
        this.parameterizedAccess = newVal;
    }

    public void setBlockNumberAccess(BlockNumberAccess newVal) {
        this.resetChoices();
        this.choice = Choices.BLOCK_NUMBER_ACCESS;
        this.blockNumberAccess = newVal;
    }

    public void setReadDataBlockAccess(ReadDataBlockAccess newVal) {
        this.resetChoices();
        this.choice = Choices.READ_DATA_BLOCK_ACCESS;
        this.readDataBlockAccess = newVal;
    }

    public void setWriteDataBlockAccess(WriteDataBlockAccess newVal) {
        this.resetChoices();
        this.choice = Choices.WRITE_DATA_BLOCK_ACCESS;
        this.writeDataBlockAccess = newVal;
    }

    private void resetChoices() {
        this.choice = Choices._ERR_NONE_SELECTED;
        this.variableName = null;
        this.parameterizedAccess = null;
        this.blockNumberAccess = null;
        this.readDataBlockAccess = null;
        this.writeDataBlockAccess = null;
    }

    public String toString() {
        if (this.choice == Choices.VARIABLE_NAME) {
            return "choice: {variableName: " + this.variableName + "}";
        }
        if (this.choice == Choices.PARAMETERIZED_ACCESS) {
            return "choice: {parameterizedAccess: " + this.parameterizedAccess + "}";
        }
        if (this.choice == Choices.BLOCK_NUMBER_ACCESS) {
            return "choice: {blockNumberAccess: " + this.blockNumberAccess + "}";
        }
        if (this.choice == Choices.READ_DATA_BLOCK_ACCESS) {
            return "choice: {readDataBlockAccess: " + this.readDataBlockAccess + "}";
        }
        if (this.choice == Choices.WRITE_DATA_BLOCK_ACCESS) {
            return "choice: {writeDataBlockAccess: " + this.writeDataBlockAccess + "}";
        }
        return "unknown";
    }

    public static enum Choices {
        _ERR_NONE_SELECTED(-1),
        VARIABLE_NAME(2),
        PARAMETERIZED_ACCESS(4),
        BLOCK_NUMBER_ACCESS(5),
        READ_DATA_BLOCK_ACCESS(6),
        WRITE_DATA_BLOCK_ACCESS(7);

        private int value;

        private Choices(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Choices valueOf(long tagValue) {
            Choices[] values;
            for (Choices c : values = Choices.values()) {
                if ((long)c.value != tagValue) continue;
                return c;
            }
            return _ERR_NONE_SELECTED;
        }
    }
}

