/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrNull;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrSequenceOf;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned16;

public class TypeDescription
implements AxdrType {
    public byte[] code = null;
    private Choices choice;
    public AxdrNull nullData = null;
    public SubSeqArray array = null;
    public SubSeqOfStructure structure = null;
    public AxdrNull bool = null;
    public AxdrNull bitString = null;
    public AxdrNull doubleLong = null;
    public AxdrNull doubleLongUnsigned = null;
    public AxdrNull octetString = null;
    public AxdrNull visibleString = null;
    public AxdrNull utf8String = null;
    public AxdrNull bcd = null;
    public AxdrNull integer = null;
    public AxdrNull longInteger = null;
    public AxdrNull unsigned = null;
    public AxdrNull longUnsigned = null;
    public AxdrNull long64 = null;
    public AxdrNull long64Unsigned = null;
    public AxdrNull enumerate = null;
    public AxdrNull float32 = null;
    public AxdrNull float64 = null;
    public AxdrNull dateTime = null;
    public AxdrNull date = null;
    public AxdrNull time = null;
    public AxdrNull dontCare = null;

    public TypeDescription() {
    }

    public TypeDescription(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
            return this.code.length;
        }
        if (this.choice == Choices._ERR_NONE_SELECTED) {
            throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
        }
        int codeLength = 0;
        if (this.choice == Choices.DONT_CARE) {
            codeLength += this.dontCare.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(255L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.TIME) {
            codeLength += this.time.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(27L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DATE) {
            codeLength += this.date.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(26L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DATE_TIME) {
            codeLength += this.dateTime.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(25L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.FLOAT64) {
            codeLength += this.float64.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(24L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.FLOAT32) {
            codeLength += this.float32.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(23L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ENUMERATE) {
            codeLength += this.enumerate.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(22L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.LONG64_UNSIGNED) {
            codeLength += this.long64Unsigned.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(21L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.LONG64) {
            codeLength += this.long64.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(20L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.LONG_UNSIGNED) {
            codeLength += this.longUnsigned.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(18L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.UNSIGNED) {
            codeLength += this.unsigned.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(17L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.LONG_INTEGER) {
            codeLength += this.longInteger.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(16L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.INTEGER) {
            codeLength += this.integer.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(15L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.BCD) {
            codeLength += this.bcd.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(13L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.UTF8_STRING) {
            codeLength += this.utf8String.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(12L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.VISIBLE_STRING) {
            codeLength += this.visibleString.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(10L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.OCTET_STRING) {
            codeLength += this.octetString.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(9L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DOUBLE_LONG_UNSIGNED) {
            codeLength += this.doubleLongUnsigned.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(6L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DOUBLE_LONG) {
            codeLength += this.doubleLong.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(5L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.BIT_STRING) {
            codeLength += this.bitString.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(4L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.BOOL) {
            codeLength += this.bool.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(3L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.STRUCTURE) {
            codeLength += this.structure.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(2L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ARRAY) {
            codeLength += this.array.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(1L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.NULL_DATA) {
            codeLength += this.nullData.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(0L);
            return codeLength += c.encode(axdrOStream);
        }
        throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrEnum choosen = new AxdrEnum();
        codeLength += choosen.decode(iStream);
        this.resetChoices();
        this.choice = Choices.valueOf(choosen.getValue());
        if (this.choice == Choices.NULL_DATA) {
            this.nullData = new AxdrNull();
            return codeLength += this.nullData.decode(iStream);
        }
        if (this.choice == Choices.ARRAY) {
            this.array = new SubSeqArray();
            return codeLength += this.array.decode(iStream);
        }
        if (this.choice == Choices.STRUCTURE) {
            this.structure = new SubSeqOfStructure();
            return codeLength += this.structure.decode(iStream);
        }
        if (this.choice == Choices.BOOL) {
            this.bool = new AxdrNull();
            return codeLength += this.bool.decode(iStream);
        }
        if (this.choice == Choices.BIT_STRING) {
            this.bitString = new AxdrNull();
            return codeLength += this.bitString.decode(iStream);
        }
        if (this.choice == Choices.DOUBLE_LONG) {
            this.doubleLong = new AxdrNull();
            return codeLength += this.doubleLong.decode(iStream);
        }
        if (this.choice == Choices.DOUBLE_LONG_UNSIGNED) {
            this.doubleLongUnsigned = new AxdrNull();
            return codeLength += this.doubleLongUnsigned.decode(iStream);
        }
        if (this.choice == Choices.OCTET_STRING) {
            this.octetString = new AxdrNull();
            return codeLength += this.octetString.decode(iStream);
        }
        if (this.choice == Choices.VISIBLE_STRING) {
            this.visibleString = new AxdrNull();
            return codeLength += this.visibleString.decode(iStream);
        }
        if (this.choice == Choices.UTF8_STRING) {
            this.utf8String = new AxdrNull();
            return codeLength += this.utf8String.decode(iStream);
        }
        if (this.choice == Choices.BCD) {
            this.bcd = new AxdrNull();
            return codeLength += this.bcd.decode(iStream);
        }
        if (this.choice == Choices.INTEGER) {
            this.integer = new AxdrNull();
            return codeLength += this.integer.decode(iStream);
        }
        if (this.choice == Choices.LONG_INTEGER) {
            this.longInteger = new AxdrNull();
            return codeLength += this.longInteger.decode(iStream);
        }
        if (this.choice == Choices.UNSIGNED) {
            this.unsigned = new AxdrNull();
            return codeLength += this.unsigned.decode(iStream);
        }
        if (this.choice == Choices.LONG_UNSIGNED) {
            this.longUnsigned = new AxdrNull();
            return codeLength += this.longUnsigned.decode(iStream);
        }
        if (this.choice == Choices.LONG64) {
            this.long64 = new AxdrNull();
            return codeLength += this.long64.decode(iStream);
        }
        if (this.choice == Choices.LONG64_UNSIGNED) {
            this.long64Unsigned = new AxdrNull();
            return codeLength += this.long64Unsigned.decode(iStream);
        }
        if (this.choice == Choices.ENUMERATE) {
            this.enumerate = new AxdrNull();
            return codeLength += this.enumerate.decode(iStream);
        }
        if (this.choice == Choices.FLOAT32) {
            this.float32 = new AxdrNull();
            return codeLength += this.float32.decode(iStream);
        }
        if (this.choice == Choices.FLOAT64) {
            this.float64 = new AxdrNull();
            return codeLength += this.float64.decode(iStream);
        }
        if (this.choice == Choices.DATE_TIME) {
            this.dateTime = new AxdrNull();
            return codeLength += this.dateTime.decode(iStream);
        }
        if (this.choice == Choices.DATE) {
            this.date = new AxdrNull();
            return codeLength += this.date.decode(iStream);
        }
        if (this.choice == Choices.TIME) {
            this.time = new AxdrNull();
            return codeLength += this.time.decode(iStream);
        }
        if (this.choice == Choices.DONT_CARE) {
            this.dontCare = new AxdrNull();
            return codeLength += this.dontCare.decode(iStream);
        }
        throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public Choices getChoiceIndex() {
        return this.choice;
    }

    public void setNullData(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.NULL_DATA;
        this.nullData = newVal;
    }

    public void setArray(SubSeqArray newVal) {
        this.resetChoices();
        this.choice = Choices.ARRAY;
        this.array = newVal;
    }

    public void setStructure(SubSeqOfStructure newVal) {
        this.resetChoices();
        this.choice = Choices.STRUCTURE;
        this.structure = newVal;
    }

    public void setBool(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.BOOL;
        this.bool = newVal;
    }

    public void setBitString(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.BIT_STRING;
        this.bitString = newVal;
    }

    public void setDoubleLong(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.DOUBLE_LONG;
        this.doubleLong = newVal;
    }

    public void setDoubleLongUnsigned(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.DOUBLE_LONG_UNSIGNED;
        this.doubleLongUnsigned = newVal;
    }

    public void setOctetString(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.OCTET_STRING;
        this.octetString = newVal;
    }

    public void setVisibleString(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.VISIBLE_STRING;
        this.visibleString = newVal;
    }

    public void setUtf8String(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.UTF8_STRING;
        this.utf8String = newVal;
    }

    public void setBcd(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.BCD;
        this.bcd = newVal;
    }

    public void setInteger(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.INTEGER;
        this.integer = newVal;
    }

    public void setLongInteger(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.LONG_INTEGER;
        this.longInteger = newVal;
    }

    public void setUnsigned(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.UNSIGNED;
        this.unsigned = newVal;
    }

    public void setLongUnsigned(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.LONG_UNSIGNED;
        this.longUnsigned = newVal;
    }

    public void setLong64(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.LONG64;
        this.long64 = newVal;
    }

    public void setLong64Unsigned(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.LONG64_UNSIGNED;
        this.long64Unsigned = newVal;
    }

    public void setEnumerate(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.ENUMERATE;
        this.enumerate = newVal;
    }

    public void setFloat32(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.FLOAT32;
        this.float32 = newVal;
    }

    public void setFloat64(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.FLOAT64;
        this.float64 = newVal;
    }

    public void setDateTime(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.DATE_TIME;
        this.dateTime = newVal;
    }

    public void setDate(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.DATE;
        this.date = newVal;
    }

    public void setTime(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.TIME;
        this.time = newVal;
    }

    public void setDontCare(AxdrNull newVal) {
        this.resetChoices();
        this.choice = Choices.DONT_CARE;
        this.dontCare = newVal;
    }

    private void resetChoices() {
        this.choice = Choices._ERR_NONE_SELECTED;
        this.nullData = null;
        this.array = null;
        this.structure = null;
        this.bool = null;
        this.bitString = null;
        this.doubleLong = null;
        this.doubleLongUnsigned = null;
        this.octetString = null;
        this.visibleString = null;
        this.utf8String = null;
        this.bcd = null;
        this.integer = null;
        this.longInteger = null;
        this.unsigned = null;
        this.longUnsigned = null;
        this.long64 = null;
        this.long64Unsigned = null;
        this.enumerate = null;
        this.float32 = null;
        this.float64 = null;
        this.dateTime = null;
        this.date = null;
        this.time = null;
        this.dontCare = null;
    }

    public String toString() {
        if (this.choice == Choices.NULL_DATA) {
            return "choice: {nullData: " + this.nullData + "}";
        }
        if (this.choice == Choices.ARRAY) {
            return "choice: {array: " + this.array + "}";
        }
        if (this.choice == Choices.STRUCTURE) {
            return "choice: {structure: " + this.structure + "}";
        }
        if (this.choice == Choices.BOOL) {
            return "choice: {bool: " + this.bool + "}";
        }
        if (this.choice == Choices.BIT_STRING) {
            return "choice: {bitString: " + this.bitString + "}";
        }
        if (this.choice == Choices.DOUBLE_LONG) {
            return "choice: {doubleLong: " + this.doubleLong + "}";
        }
        if (this.choice == Choices.DOUBLE_LONG_UNSIGNED) {
            return "choice: {doubleLongUnsigned: " + this.doubleLongUnsigned + "}";
        }
        if (this.choice == Choices.OCTET_STRING) {
            return "choice: {octetString: " + this.octetString + "}";
        }
        if (this.choice == Choices.VISIBLE_STRING) {
            return "choice: {visibleString: " + this.visibleString + "}";
        }
        if (this.choice == Choices.UTF8_STRING) {
            return "choice: {utf8String: " + this.utf8String + "}";
        }
        if (this.choice == Choices.BCD) {
            return "choice: {bcd: " + this.bcd + "}";
        }
        if (this.choice == Choices.INTEGER) {
            return "choice: {integer: " + this.integer + "}";
        }
        if (this.choice == Choices.LONG_INTEGER) {
            return "choice: {longInteger: " + this.longInteger + "}";
        }
        if (this.choice == Choices.UNSIGNED) {
            return "choice: {unsigned: " + this.unsigned + "}";
        }
        if (this.choice == Choices.LONG_UNSIGNED) {
            return "choice: {longUnsigned: " + this.longUnsigned + "}";
        }
        if (this.choice == Choices.LONG64) {
            return "choice: {long64: " + this.long64 + "}";
        }
        if (this.choice == Choices.LONG64_UNSIGNED) {
            return "choice: {long64Unsigned: " + this.long64Unsigned + "}";
        }
        if (this.choice == Choices.ENUMERATE) {
            return "choice: {enumerate: " + this.enumerate + "}";
        }
        if (this.choice == Choices.FLOAT32) {
            return "choice: {float32: " + this.float32 + "}";
        }
        if (this.choice == Choices.FLOAT64) {
            return "choice: {float64: " + this.float64 + "}";
        }
        if (this.choice == Choices.DATE_TIME) {
            return "choice: {dateTime: " + this.dateTime + "}";
        }
        if (this.choice == Choices.DATE) {
            return "choice: {date: " + this.date + "}";
        }
        if (this.choice == Choices.TIME) {
            return "choice: {time: " + this.time + "}";
        }
        if (this.choice == Choices.DONT_CARE) {
            return "choice: {dontCare: " + this.dontCare + "}";
        }
        return "unknown";
    }

    public static class SubSeqOfStructure
    extends AxdrSequenceOf<TypeDescription> {
        @Override
        protected TypeDescription createListElement() {
            return new TypeDescription();
        }

        protected SubSeqOfStructure(int length) {
            super(length);
        }

        public SubSeqOfStructure() {
        }
    }

    public static class SubSeqArray
    implements AxdrType {
        public byte[] code = null;
        public Unsigned16 numberOfElements = null;
        public TypeDescription typeDescription = null;

        public SubSeqArray() {
        }

        public SubSeqArray(byte[] code) {
            this.code = code;
        }

        public SubSeqArray(Unsigned16 numberOfElements, TypeDescription typeDescription) {
            this.numberOfElements = numberOfElements;
            this.typeDescription = typeDescription;
        }

        @Override
        public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
            int codeLength;
            if (this.code != null) {
                codeLength = this.code.length;
                for (int i = this.code.length - 1; i >= 0; --i) {
                    axdrOStream.write(this.code[i]);
                }
            } else {
                codeLength = 0;
                codeLength += this.typeDescription.encode(axdrOStream);
                codeLength += this.numberOfElements.encode(axdrOStream);
            }
            return codeLength;
        }

        @Override
        public int decode(InputStream iStream) throws IOException {
            int codeLength = 0;
            this.numberOfElements = new Unsigned16();
            codeLength += this.numberOfElements.decode(iStream);
            this.typeDescription = new TypeDescription();
            return codeLength += this.typeDescription.decode(iStream);
        }

        public void encodeAndSave(int encodingSizeGuess) throws IOException {
            ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
            this.encode(axdrOStream);
            this.code = axdrOStream.getArray();
        }

        public String toString() {
            return "sequence: {numberOfElements: " + this.numberOfElements + ", typeDescription: " + this.typeDescription + "}";
        }
    }

    public static enum Choices {
        _ERR_NONE_SELECTED(-1),
        NULL_DATA(0),
        ARRAY(1),
        STRUCTURE(2),
        BOOL(3),
        BIT_STRING(4),
        DOUBLE_LONG(5),
        DOUBLE_LONG_UNSIGNED(6),
        OCTET_STRING(9),
        VISIBLE_STRING(10),
        UTF8_STRING(12),
        BCD(13),
        INTEGER(15),
        LONG_INTEGER(16),
        UNSIGNED(17),
        LONG_UNSIGNED(18),
        LONG64(20),
        LONG64_UNSIGNED(21),
        ENUMERATE(22),
        FLOAT32(23),
        FLOAT64(24),
        DATE_TIME(25),
        DATE(26),
        TIME(27),
        DONT_CARE(255);

        private int value;

        private Choices(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Choices valueOf(long tagValue) {
            Choices[] values;
            for (Choices c : values = Choices.values()) {
                if ((long)c.value != tagValue) continue;
                return c;
            }
            return _ERR_NONE_SELECTED;
        }
    }
}

