/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.cosem.SetResponseDatablock;
import org.openmuc.jdlms.internal.asn1.cosem.SetResponseLastDatablock;
import org.openmuc.jdlms.internal.asn1.cosem.SetResponseLastDatablockWithList;
import org.openmuc.jdlms.internal.asn1.cosem.SetResponseNormal;
import org.openmuc.jdlms.internal.asn1.cosem.SetResponseWithList;

public class SetResponse
implements AxdrType {
    public byte[] code = null;
    private Choices choice;
    public SetResponseNormal setResponseNormal = null;
    public SetResponseDatablock setResponseDatablock = null;
    public SetResponseLastDatablock setResponseLastDatablock = null;
    public SetResponseLastDatablockWithList setResponseLastDatablockWithList = null;
    public SetResponseWithList setResponseWithList = null;

    public SetResponse() {
    }

    public SetResponse(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
            return this.code.length;
        }
        if (this.choice == Choices._ERR_NONE_SELECTED) {
            throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
        }
        int codeLength = 0;
        if (this.choice == Choices.SET_RESPONSE_WITH_LIST) {
            codeLength += this.setResponseWithList.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(5L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.SET_RESPONSE_LAST_DATABLOCK_WITH_LIST) {
            codeLength += this.setResponseLastDatablockWithList.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(4L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.SET_RESPONSE_LAST_DATABLOCK) {
            codeLength += this.setResponseLastDatablock.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(3L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.SET_RESPONSE_DATABLOCK) {
            codeLength += this.setResponseDatablock.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(2L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.SET_RESPONSE_NORMAL) {
            codeLength += this.setResponseNormal.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(1L);
            return codeLength += c.encode(axdrOStream);
        }
        throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrEnum choosen = new AxdrEnum();
        codeLength += choosen.decode(iStream);
        this.resetChoices();
        this.choice = Choices.valueOf(choosen.getValue());
        if (this.choice == Choices.SET_RESPONSE_NORMAL) {
            this.setResponseNormal = new SetResponseNormal();
            return codeLength += this.setResponseNormal.decode(iStream);
        }
        if (this.choice == Choices.SET_RESPONSE_DATABLOCK) {
            this.setResponseDatablock = new SetResponseDatablock();
            return codeLength += this.setResponseDatablock.decode(iStream);
        }
        if (this.choice == Choices.SET_RESPONSE_LAST_DATABLOCK) {
            this.setResponseLastDatablock = new SetResponseLastDatablock();
            return codeLength += this.setResponseLastDatablock.decode(iStream);
        }
        if (this.choice == Choices.SET_RESPONSE_LAST_DATABLOCK_WITH_LIST) {
            this.setResponseLastDatablockWithList = new SetResponseLastDatablockWithList();
            return codeLength += this.setResponseLastDatablockWithList.decode(iStream);
        }
        if (this.choice == Choices.SET_RESPONSE_WITH_LIST) {
            this.setResponseWithList = new SetResponseWithList();
            return codeLength += this.setResponseWithList.decode(iStream);
        }
        throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public Choices getChoiceIndex() {
        return this.choice;
    }

    public void setSetResponseNormal(SetResponseNormal newVal) {
        this.resetChoices();
        this.choice = Choices.SET_RESPONSE_NORMAL;
        this.setResponseNormal = newVal;
    }

    public void setSetResponseDatablock(SetResponseDatablock newVal) {
        this.resetChoices();
        this.choice = Choices.SET_RESPONSE_DATABLOCK;
        this.setResponseDatablock = newVal;
    }

    public void setSetResponseLastDatablock(SetResponseLastDatablock newVal) {
        this.resetChoices();
        this.choice = Choices.SET_RESPONSE_LAST_DATABLOCK;
        this.setResponseLastDatablock = newVal;
    }

    public void setSetResponseLastDatablockWithList(SetResponseLastDatablockWithList newVal) {
        this.resetChoices();
        this.choice = Choices.SET_RESPONSE_LAST_DATABLOCK_WITH_LIST;
        this.setResponseLastDatablockWithList = newVal;
    }

    public void setSetResponseWithList(SetResponseWithList newVal) {
        this.resetChoices();
        this.choice = Choices.SET_RESPONSE_WITH_LIST;
        this.setResponseWithList = newVal;
    }

    private void resetChoices() {
        this.choice = Choices._ERR_NONE_SELECTED;
        this.setResponseNormal = null;
        this.setResponseDatablock = null;
        this.setResponseLastDatablock = null;
        this.setResponseLastDatablockWithList = null;
        this.setResponseWithList = null;
    }

    public String toString() {
        if (this.choice == Choices.SET_RESPONSE_NORMAL) {
            return "choice: {setResponseNormal: " + this.setResponseNormal + "}";
        }
        if (this.choice == Choices.SET_RESPONSE_DATABLOCK) {
            return "choice: {setResponseDatablock: " + this.setResponseDatablock + "}";
        }
        if (this.choice == Choices.SET_RESPONSE_LAST_DATABLOCK) {
            return "choice: {setResponseLastDatablock: " + this.setResponseLastDatablock + "}";
        }
        if (this.choice == Choices.SET_RESPONSE_LAST_DATABLOCK_WITH_LIST) {
            return "choice: {setResponseLastDatablockWithList: " + this.setResponseLastDatablockWithList + "}";
        }
        if (this.choice == Choices.SET_RESPONSE_WITH_LIST) {
            return "choice: {setResponseWithList: " + this.setResponseWithList + "}";
        }
        return "unknown";
    }

    public static enum Choices {
        _ERR_NONE_SELECTED(-1),
        SET_RESPONSE_NORMAL(1),
        SET_RESPONSE_DATABLOCK(2),
        SET_RESPONSE_LAST_DATABLOCK(3),
        SET_RESPONSE_LAST_DATABLOCK_WITH_LIST(4),
        SET_RESPONSE_WITH_LIST(5);

        private int value;

        private Choices(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Choices valueOf(long tagValue) {
            Choices[] values;
            for (Choices c : values = Choices.values()) {
                if ((long)c.value != tagValue) continue;
                return c;
            }
            return _ERR_NONE_SELECTED;
        }
    }
}

