/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOptional;
import org.openmuc.jdlms.internal.asn1.cosem.CosemAttributeDescriptor;
import org.openmuc.jdlms.internal.asn1.cosem.Data;
import org.openmuc.jdlms.internal.asn1.cosem.InvokeIdAndPriority;
import org.openmuc.jdlms.internal.asn1.cosem.SelectiveAccessDescriptor;

public class SetRequestNormal
implements AxdrType {
    public byte[] code = null;
    public InvokeIdAndPriority invokeIdAndPriority = null;
    public CosemAttributeDescriptor cosemAttributeDescriptor = null;
    public AxdrOptional<SelectiveAccessDescriptor> accessSelection = new AxdrOptional<SelectiveAccessDescriptor>(new SelectiveAccessDescriptor(), false);
    public Data value = null;

    public SetRequestNormal() {
    }

    public SetRequestNormal(byte[] code) {
        this.code = code;
    }

    public SetRequestNormal(InvokeIdAndPriority invokeIdAndPriority, CosemAttributeDescriptor cosemAttributeDescriptor, SelectiveAccessDescriptor accessSelection, Data value) {
        this.invokeIdAndPriority = invokeIdAndPriority;
        this.cosemAttributeDescriptor = cosemAttributeDescriptor;
        this.accessSelection.setValue(accessSelection);
        this.value = value;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.value.encode(axdrOStream);
            codeLength += this.accessSelection.encode(axdrOStream);
            codeLength += this.cosemAttributeDescriptor.encode(axdrOStream);
            codeLength += this.invokeIdAndPriority.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.invokeIdAndPriority = new InvokeIdAndPriority();
        codeLength += this.invokeIdAndPriority.decode(iStream);
        this.cosemAttributeDescriptor = new CosemAttributeDescriptor();
        codeLength += this.cosemAttributeDescriptor.decode(iStream);
        this.accessSelection = new AxdrOptional<SelectiveAccessDescriptor>(new SelectiveAccessDescriptor(), false);
        codeLength += this.accessSelection.decode(iStream);
        this.value = new Data();
        return codeLength += this.value.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {invokeIdAndPriority: " + this.invokeIdAndPriority + ", cosemAttributeDescriptor: " + this.cosemAttributeDescriptor + ", accessSelection: " + this.accessSelection + ", value: " + this.value + "}";
    }
}

