/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.cosem.SetRequestNormal;
import org.openmuc.jdlms.internal.asn1.cosem.SetRequestWithDatablock;
import org.openmuc.jdlms.internal.asn1.cosem.SetRequestWithFirstDatablock;
import org.openmuc.jdlms.internal.asn1.cosem.SetRequestWithList;
import org.openmuc.jdlms.internal.asn1.cosem.SetRequestWithListAndFirstDatablock;

public class SetRequest
implements AxdrType {
    public byte[] code = null;
    private Choices choice;
    public SetRequestNormal setRequestNormal = null;
    public SetRequestWithFirstDatablock setRequestWithFirstDatablock = null;
    public SetRequestWithDatablock setRequestWithDatablock = null;
    public SetRequestWithList setRequestWithList = null;
    public SetRequestWithListAndFirstDatablock setRequestWithListAndFirstDatablock = null;

    public SetRequest() {
    }

    public SetRequest(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
            return this.code.length;
        }
        if (this.choice == Choices._ERR_NONE_SELECTED) {
            throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
        }
        int codeLength = 0;
        if (this.choice == Choices.SET_REQUEST_WITH_LIST_AND_FIRST_DATABLOCK) {
            codeLength += this.setRequestWithListAndFirstDatablock.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(5L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.SET_REQUEST_WITH_LIST) {
            codeLength += this.setRequestWithList.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(4L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.SET_REQUEST_WITH_DATABLOCK) {
            codeLength += this.setRequestWithDatablock.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(3L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.SET_REQUEST_WITH_FIRST_DATABLOCK) {
            codeLength += this.setRequestWithFirstDatablock.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(2L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.SET_REQUEST_NORMAL) {
            codeLength += this.setRequestNormal.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(1L);
            return codeLength += c.encode(axdrOStream);
        }
        throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrEnum choosen = new AxdrEnum();
        codeLength += choosen.decode(iStream);
        this.resetChoices();
        this.choice = Choices.valueOf(choosen.getValue());
        if (this.choice == Choices.SET_REQUEST_NORMAL) {
            this.setRequestNormal = new SetRequestNormal();
            return codeLength += this.setRequestNormal.decode(iStream);
        }
        if (this.choice == Choices.SET_REQUEST_WITH_FIRST_DATABLOCK) {
            this.setRequestWithFirstDatablock = new SetRequestWithFirstDatablock();
            return codeLength += this.setRequestWithFirstDatablock.decode(iStream);
        }
        if (this.choice == Choices.SET_REQUEST_WITH_DATABLOCK) {
            this.setRequestWithDatablock = new SetRequestWithDatablock();
            return codeLength += this.setRequestWithDatablock.decode(iStream);
        }
        if (this.choice == Choices.SET_REQUEST_WITH_LIST) {
            this.setRequestWithList = new SetRequestWithList();
            return codeLength += this.setRequestWithList.decode(iStream);
        }
        if (this.choice == Choices.SET_REQUEST_WITH_LIST_AND_FIRST_DATABLOCK) {
            this.setRequestWithListAndFirstDatablock = new SetRequestWithListAndFirstDatablock();
            return codeLength += this.setRequestWithListAndFirstDatablock.decode(iStream);
        }
        throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public Choices getChoiceIndex() {
        return this.choice;
    }

    public void setSetRequestNormal(SetRequestNormal newVal) {
        this.resetChoices();
        this.choice = Choices.SET_REQUEST_NORMAL;
        this.setRequestNormal = newVal;
    }

    public void setSetRequestWithFirstDatablock(SetRequestWithFirstDatablock newVal) {
        this.resetChoices();
        this.choice = Choices.SET_REQUEST_WITH_FIRST_DATABLOCK;
        this.setRequestWithFirstDatablock = newVal;
    }

    public void setSetRequestWithDatablock(SetRequestWithDatablock newVal) {
        this.resetChoices();
        this.choice = Choices.SET_REQUEST_WITH_DATABLOCK;
        this.setRequestWithDatablock = newVal;
    }

    public void setSetRequestWithList(SetRequestWithList newVal) {
        this.resetChoices();
        this.choice = Choices.SET_REQUEST_WITH_LIST;
        this.setRequestWithList = newVal;
    }

    public void setSetRequestWithListAndFirstDatablock(SetRequestWithListAndFirstDatablock newVal) {
        this.resetChoices();
        this.choice = Choices.SET_REQUEST_WITH_LIST_AND_FIRST_DATABLOCK;
        this.setRequestWithListAndFirstDatablock = newVal;
    }

    private void resetChoices() {
        this.choice = Choices._ERR_NONE_SELECTED;
        this.setRequestNormal = null;
        this.setRequestWithFirstDatablock = null;
        this.setRequestWithDatablock = null;
        this.setRequestWithList = null;
        this.setRequestWithListAndFirstDatablock = null;
    }

    public String toString() {
        if (this.choice == Choices.SET_REQUEST_NORMAL) {
            return "choice: {setRequestNormal: " + this.setRequestNormal + "}";
        }
        if (this.choice == Choices.SET_REQUEST_WITH_FIRST_DATABLOCK) {
            return "choice: {setRequestWithFirstDatablock: " + this.setRequestWithFirstDatablock + "}";
        }
        if (this.choice == Choices.SET_REQUEST_WITH_DATABLOCK) {
            return "choice: {setRequestWithDatablock: " + this.setRequestWithDatablock + "}";
        }
        if (this.choice == Choices.SET_REQUEST_WITH_LIST) {
            return "choice: {setRequestWithList: " + this.setRequestWithList + "}";
        }
        if (this.choice == Choices.SET_REQUEST_WITH_LIST_AND_FIRST_DATABLOCK) {
            return "choice: {setRequestWithListAndFirstDatablock: " + this.setRequestWithListAndFirstDatablock + "}";
        }
        return "unknown";
    }

    public static enum Choices {
        _ERR_NONE_SELECTED(-1),
        SET_REQUEST_NORMAL(1),
        SET_REQUEST_WITH_FIRST_DATABLOCK(2),
        SET_REQUEST_WITH_DATABLOCK(3),
        SET_REQUEST_WITH_LIST(4),
        SET_REQUEST_WITH_LIST_AND_FIRST_DATABLOCK(5);

        private int value;

        private Choices(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Choices valueOf(long tagValue) {
            Choices[] values;
            for (Choices c : values = Choices.values()) {
                if ((long)c.value != tagValue) continue;
                return c;
            }
            return _ERR_NONE_SELECTED;
        }
    }
}

