/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;

public class ServiceError
implements AxdrType {
    public byte[] code = null;
    private Choices choice;
    public AxdrEnum applicationReference = null;
    public AxdrEnum hardwareResource = null;
    public AxdrEnum vdeStateError = null;
    public AxdrEnum service = null;
    public AxdrEnum definition = null;
    public AxdrEnum access = null;
    public AxdrEnum initiate = null;
    public AxdrEnum loadDataSet = null;
    public AxdrEnum task = null;

    public ServiceError() {
    }

    public ServiceError(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
            return this.code.length;
        }
        if (this.choice == Choices._ERR_NONE_SELECTED) {
            throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
        }
        int codeLength = 0;
        if (this.choice == Choices.TASK) {
            codeLength += this.task.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(9L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.LOAD_DATA_SET) {
            codeLength += this.loadDataSet.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(7L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.INITIATE) {
            codeLength += this.initiate.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(6L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.ACCESS) {
            codeLength += this.access.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(5L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.DEFINITION) {
            codeLength += this.definition.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(4L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.SERVICE) {
            codeLength += this.service.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(3L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.VDE_STATE_ERROR) {
            codeLength += this.vdeStateError.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(2L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.HARDWARE_RESOURCE) {
            codeLength += this.hardwareResource.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(1L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.APPLICATION_REFERENCE) {
            codeLength += this.applicationReference.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(0L);
            return codeLength += c.encode(axdrOStream);
        }
        throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrEnum choosen = new AxdrEnum();
        codeLength += choosen.decode(iStream);
        this.resetChoices();
        this.choice = Choices.valueOf(choosen.getValue());
        if (this.choice == Choices.APPLICATION_REFERENCE) {
            this.applicationReference = new AxdrEnum();
            return codeLength += this.applicationReference.decode(iStream);
        }
        if (this.choice == Choices.HARDWARE_RESOURCE) {
            this.hardwareResource = new AxdrEnum();
            return codeLength += this.hardwareResource.decode(iStream);
        }
        if (this.choice == Choices.VDE_STATE_ERROR) {
            this.vdeStateError = new AxdrEnum();
            return codeLength += this.vdeStateError.decode(iStream);
        }
        if (this.choice == Choices.SERVICE) {
            this.service = new AxdrEnum();
            return codeLength += this.service.decode(iStream);
        }
        if (this.choice == Choices.DEFINITION) {
            this.definition = new AxdrEnum();
            return codeLength += this.definition.decode(iStream);
        }
        if (this.choice == Choices.ACCESS) {
            this.access = new AxdrEnum();
            return codeLength += this.access.decode(iStream);
        }
        if (this.choice == Choices.INITIATE) {
            this.initiate = new AxdrEnum();
            return codeLength += this.initiate.decode(iStream);
        }
        if (this.choice == Choices.LOAD_DATA_SET) {
            this.loadDataSet = new AxdrEnum();
            return codeLength += this.loadDataSet.decode(iStream);
        }
        if (this.choice == Choices.TASK) {
            this.task = new AxdrEnum();
            return codeLength += this.task.decode(iStream);
        }
        throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public Choices getChoiceIndex() {
        return this.choice;
    }

    public void setApplicationReference(AxdrEnum newVal) {
        this.resetChoices();
        this.choice = Choices.APPLICATION_REFERENCE;
        this.applicationReference = newVal;
    }

    public void setHardwareResource(AxdrEnum newVal) {
        this.resetChoices();
        this.choice = Choices.HARDWARE_RESOURCE;
        this.hardwareResource = newVal;
    }

    public void setVdeStateError(AxdrEnum newVal) {
        this.resetChoices();
        this.choice = Choices.VDE_STATE_ERROR;
        this.vdeStateError = newVal;
    }

    public void setService(AxdrEnum newVal) {
        this.resetChoices();
        this.choice = Choices.SERVICE;
        this.service = newVal;
    }

    public void setDefinition(AxdrEnum newVal) {
        this.resetChoices();
        this.choice = Choices.DEFINITION;
        this.definition = newVal;
    }

    public void setAccess(AxdrEnum newVal) {
        this.resetChoices();
        this.choice = Choices.ACCESS;
        this.access = newVal;
    }

    public void setInitiate(AxdrEnum newVal) {
        this.resetChoices();
        this.choice = Choices.INITIATE;
        this.initiate = newVal;
    }

    public void setLoadDataSet(AxdrEnum newVal) {
        this.resetChoices();
        this.choice = Choices.LOAD_DATA_SET;
        this.loadDataSet = newVal;
    }

    public void setTask(AxdrEnum newVal) {
        this.resetChoices();
        this.choice = Choices.TASK;
        this.task = newVal;
    }

    private void resetChoices() {
        this.choice = Choices._ERR_NONE_SELECTED;
        this.applicationReference = null;
        this.hardwareResource = null;
        this.vdeStateError = null;
        this.service = null;
        this.definition = null;
        this.access = null;
        this.initiate = null;
        this.loadDataSet = null;
        this.task = null;
    }

    public String toString() {
        if (this.choice == Choices.APPLICATION_REFERENCE) {
            return "choice: {applicationReference: " + this.applicationReference + "}";
        }
        if (this.choice == Choices.HARDWARE_RESOURCE) {
            return "choice: {hardwareResource: " + this.hardwareResource + "}";
        }
        if (this.choice == Choices.VDE_STATE_ERROR) {
            return "choice: {vdeStateError: " + this.vdeStateError + "}";
        }
        if (this.choice == Choices.SERVICE) {
            return "choice: {service: " + this.service + "}";
        }
        if (this.choice == Choices.DEFINITION) {
            return "choice: {definition: " + this.definition + "}";
        }
        if (this.choice == Choices.ACCESS) {
            return "choice: {access: " + this.access + "}";
        }
        if (this.choice == Choices.INITIATE) {
            return "choice: {initiate: " + this.initiate + "}";
        }
        if (this.choice == Choices.LOAD_DATA_SET) {
            return "choice: {loadDataSet: " + this.loadDataSet + "}";
        }
        if (this.choice == Choices.TASK) {
            return "choice: {task: " + this.task + "}";
        }
        return "unknown";
    }

    public static enum Choices {
        _ERR_NONE_SELECTED(-1),
        APPLICATION_REFERENCE(0),
        HARDWARE_RESOURCE(1),
        VDE_STATE_ERROR(2),
        SERVICE(3),
        DEFINITION(4),
        ACCESS(5),
        INITIATE(6),
        LOAD_DATA_SET(7),
        TASK(9);

        private int value;

        private Choices(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Choices valueOf(long tagValue) {
            Choices[] values;
            for (Choices c : values = Choices.values()) {
                if ((long)c.value != tagValue) continue;
                return c;
            }
            return _ERR_NONE_SELECTED;
        }
    }
}

