/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.cosem.Data;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned8;

public class SelectiveAccessDescriptor
implements AxdrType {
    public byte[] code = null;
    public Unsigned8 accessSelector = null;
    public Data accessParameters = null;

    public SelectiveAccessDescriptor() {
    }

    public SelectiveAccessDescriptor(byte[] code) {
        this.code = code;
    }

    public SelectiveAccessDescriptor(Unsigned8 accessSelector, Data accessParameters) {
        this.accessSelector = accessSelector;
        this.accessParameters = accessParameters;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.accessParameters.encode(axdrOStream);
            codeLength += this.accessSelector.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.accessSelector = new Unsigned8();
        codeLength += this.accessSelector.decode(iStream);
        this.accessParameters = new Data();
        return codeLength += this.accessParameters.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {accessSelector: " + this.accessSelector + ", accessParameters: " + this.accessParameters + "}";
    }
}

