/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrBoolean;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrDefault;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOctetString;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOptional;
import org.openmuc.jdlms.internal.asn1.cosem.Conformance;
import org.openmuc.jdlms.internal.asn1.cosem.Integer8;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned16;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned8;

public class InitiateRequest
implements AxdrType {
    public byte[] code = null;
    public AxdrOptional<AxdrOctetString> dedicatedKey = new AxdrOptional<AxdrOctetString>(new AxdrOctetString(), false);
    public AxdrDefault<AxdrBoolean> responseAllowed = new AxdrDefault<AxdrBoolean>(new AxdrBoolean(), new AxdrBoolean(true));
    public AxdrOptional<Integer8> proposedQualityOfService = new AxdrOptional<Integer8>(new Integer8(), false);
    public Unsigned8 proposedDlmsVersionNumber = null;
    public Conformance proposedConformance = null;
    public Unsigned16 clientMaxReceivePduSize = null;

    public InitiateRequest() {
    }

    public InitiateRequest(byte[] code) {
        this.code = code;
    }

    public InitiateRequest(AxdrOctetString dedicatedKey, AxdrBoolean responseAllowed, Integer8 proposedQualityOfService, Unsigned8 proposedDlmsVersionNumber, Conformance proposedConformance, Unsigned16 clientMaxReceivePduSize) {
        this.dedicatedKey.setValue(dedicatedKey);
        this.responseAllowed.setValue(responseAllowed);
        this.proposedQualityOfService.setValue(proposedQualityOfService);
        this.proposedDlmsVersionNumber = proposedDlmsVersionNumber;
        this.proposedConformance = proposedConformance;
        this.clientMaxReceivePduSize = clientMaxReceivePduSize;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.clientMaxReceivePduSize.encode(axdrOStream);
            codeLength += this.proposedConformance.encode(axdrOStream);
            codeLength += this.proposedDlmsVersionNumber.encode(axdrOStream);
            codeLength += this.proposedQualityOfService.encode(axdrOStream);
            codeLength += this.responseAllowed.encode(axdrOStream);
            codeLength += this.dedicatedKey.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.dedicatedKey = new AxdrOptional<AxdrOctetString>(new AxdrOctetString(), false);
        codeLength += this.dedicatedKey.decode(iStream);
        this.responseAllowed = new AxdrDefault<AxdrBoolean>(new AxdrBoolean(), new AxdrBoolean(true));
        codeLength += this.responseAllowed.decode(iStream);
        this.proposedQualityOfService = new AxdrOptional<Integer8>(new Integer8(), false);
        codeLength += this.proposedQualityOfService.decode(iStream);
        this.proposedDlmsVersionNumber = new Unsigned8();
        codeLength += this.proposedDlmsVersionNumber.decode(iStream);
        this.proposedConformance = new Conformance();
        codeLength += this.proposedConformance.decode(iStream);
        this.clientMaxReceivePduSize = new Unsigned16();
        return codeLength += this.clientMaxReceivePduSize.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {dedicatedKey: " + this.dedicatedKey + ", responseAllowed: " + this.responseAllowed + ", proposedQualityOfService: " + this.proposedQualityOfService + ", proposedDlmsVersionNumber: " + this.proposedDlmsVersionNumber + ", proposedConformance: " + (Object)((Object)this.proposedConformance) + ", clientMaxReceivePduSize: " + this.clientMaxReceivePduSize + "}";
    }
}

