/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.cosem.InvokeIdAndPriority;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned32;

public class GetRequestNext
implements AxdrType {
    public byte[] code = null;
    public InvokeIdAndPriority invokeIdAndPriority = null;
    public Unsigned32 blockNumber = null;

    public GetRequestNext() {
    }

    public GetRequestNext(byte[] code) {
        this.code = code;
    }

    public GetRequestNext(InvokeIdAndPriority invokeIdAndPriority, Unsigned32 blockNumber) {
        this.invokeIdAndPriority = invokeIdAndPriority;
        this.blockNumber = blockNumber;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.blockNumber.encode(axdrOStream);
            codeLength += this.invokeIdAndPriority.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.invokeIdAndPriority = new InvokeIdAndPriority();
        codeLength += this.invokeIdAndPriority.decode(iStream);
        this.blockNumber = new Unsigned32();
        return codeLength += this.blockNumber.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {invokeIdAndPriority: " + this.invokeIdAndPriority + ", blockNumber: " + this.blockNumber + "}";
    }
}

