/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrEnum;
import org.openmuc.jdlms.internal.asn1.cosem.GetRequestNext;
import org.openmuc.jdlms.internal.asn1.cosem.GetRequestNormal;
import org.openmuc.jdlms.internal.asn1.cosem.GetRequestWithList;

public class GetRequest
implements AxdrType {
    public byte[] code = null;
    private Choices choice;
    public GetRequestNormal getRequestNormal = null;
    public GetRequestNext getRequestNext = null;
    public GetRequestWithList getRequestWithList = null;

    public GetRequest() {
    }

    public GetRequest(byte[] code) {
        this.code = code;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        if (this.code != null) {
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
            return this.code.length;
        }
        if (this.choice == Choices._ERR_NONE_SELECTED) {
            throw new IOException("Error encoding AxdrChoice: No item in choice was selected.");
        }
        int codeLength = 0;
        if (this.choice == Choices.GET_REQUEST_WITH_LIST) {
            codeLength += this.getRequestWithList.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(3L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GET_REQUEST_NEXT) {
            codeLength += this.getRequestNext.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(2L);
            return codeLength += c.encode(axdrOStream);
        }
        if (this.choice == Choices.GET_REQUEST_NORMAL) {
            codeLength += this.getRequestNormal.encode(axdrOStream);
            AxdrEnum c = new AxdrEnum(1L);
            return codeLength += c.encode(axdrOStream);
        }
        throw new IOException("Error encoding AxdrChoice: No item in choice was encoded.");
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        AxdrEnum choosen = new AxdrEnum();
        codeLength += choosen.decode(iStream);
        this.resetChoices();
        this.choice = Choices.valueOf(choosen.getValue());
        if (this.choice == Choices.GET_REQUEST_NORMAL) {
            this.getRequestNormal = new GetRequestNormal();
            return codeLength += this.getRequestNormal.decode(iStream);
        }
        if (this.choice == Choices.GET_REQUEST_NEXT) {
            this.getRequestNext = new GetRequestNext();
            return codeLength += this.getRequestNext.decode(iStream);
        }
        if (this.choice == Choices.GET_REQUEST_WITH_LIST) {
            this.getRequestWithList = new GetRequestWithList();
            return codeLength += this.getRequestWithList.decode(iStream);
        }
        throw new IOException("Error decoding AxdrChoice: Identifier matched to no item.");
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public Choices getChoiceIndex() {
        return this.choice;
    }

    public void setGetRequestNormal(GetRequestNormal newVal) {
        this.resetChoices();
        this.choice = Choices.GET_REQUEST_NORMAL;
        this.getRequestNormal = newVal;
    }

    public void setGetRequestNext(GetRequestNext newVal) {
        this.resetChoices();
        this.choice = Choices.GET_REQUEST_NEXT;
        this.getRequestNext = newVal;
    }

    public void setGetRequestWithList(GetRequestWithList newVal) {
        this.resetChoices();
        this.choice = Choices.GET_REQUEST_WITH_LIST;
        this.getRequestWithList = newVal;
    }

    private void resetChoices() {
        this.choice = Choices._ERR_NONE_SELECTED;
        this.getRequestNormal = null;
        this.getRequestNext = null;
        this.getRequestWithList = null;
    }

    public String toString() {
        if (this.choice == Choices.GET_REQUEST_NORMAL) {
            return "choice: {getRequestNormal: " + this.getRequestNormal + "}";
        }
        if (this.choice == Choices.GET_REQUEST_NEXT) {
            return "choice: {getRequestNext: " + this.getRequestNext + "}";
        }
        if (this.choice == Choices.GET_REQUEST_WITH_LIST) {
            return "choice: {getRequestWithList: " + this.getRequestWithList + "}";
        }
        return "unknown";
    }

    public static enum Choices {
        _ERR_NONE_SELECTED(-1),
        GET_REQUEST_NORMAL(1),
        GET_REQUEST_NEXT(2),
        GET_REQUEST_WITH_LIST(3);

        private int value;

        private Choices(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Choices valueOf(long tagValue) {
            Choices[] values;
            for (Choices c : values = Choices.values()) {
                if ((long)c.value != tagValue) continue;
                return c;
            }
            return _ERR_NONE_SELECTED;
        }
    }
}

