/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOctetString;

public class GeneralSigning
implements AxdrType {
    public byte[] code = null;
    public AxdrOctetString transactionId = null;
    public AxdrOctetString originatorSystemTitle = null;
    public AxdrOctetString recipientSystemTitle = null;
    public AxdrOctetString dateTime = null;
    public AxdrOctetString otherInformation = null;
    public AxdrOctetString content = null;
    public AxdrOctetString signature = null;

    public GeneralSigning() {
    }

    public GeneralSigning(byte[] code) {
        this.code = code;
    }

    public GeneralSigning(AxdrOctetString transactionId, AxdrOctetString originatorSystemTitle, AxdrOctetString recipientSystemTitle, AxdrOctetString dateTime, AxdrOctetString otherInformation, AxdrOctetString content, AxdrOctetString signature) {
        this.transactionId = transactionId;
        this.originatorSystemTitle = originatorSystemTitle;
        this.recipientSystemTitle = recipientSystemTitle;
        this.dateTime = dateTime;
        this.otherInformation = otherInformation;
        this.content = content;
        this.signature = signature;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.signature.encode(axdrOStream);
            codeLength += this.content.encode(axdrOStream);
            codeLength += this.otherInformation.encode(axdrOStream);
            codeLength += this.dateTime.encode(axdrOStream);
            codeLength += this.recipientSystemTitle.encode(axdrOStream);
            codeLength += this.originatorSystemTitle.encode(axdrOStream);
            codeLength += this.transactionId.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.transactionId = new AxdrOctetString();
        codeLength += this.transactionId.decode(iStream);
        this.originatorSystemTitle = new AxdrOctetString();
        codeLength += this.originatorSystemTitle.decode(iStream);
        this.recipientSystemTitle = new AxdrOctetString();
        codeLength += this.recipientSystemTitle.decode(iStream);
        this.dateTime = new AxdrOctetString();
        codeLength += this.dateTime.decode(iStream);
        this.otherInformation = new AxdrOctetString();
        codeLength += this.otherInformation.decode(iStream);
        this.content = new AxdrOctetString();
        codeLength += this.content.decode(iStream);
        this.signature = new AxdrOctetString();
        return codeLength += this.signature.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {transactionId: " + this.transactionId + ", originatorSystemTitle: " + this.originatorSystemTitle + ", recipientSystemTitle: " + this.recipientSystemTitle + ", dateTime: " + this.dateTime + ", otherInformation: " + this.otherInformation + ", content: " + this.content + ", signature: " + this.signature + "}";
    }
}

