/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.axdr.types.AxdrOctetString;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned16;
import org.openmuc.jdlms.internal.asn1.cosem.Unsigned8;

public class GeneralBlockTransfer
implements AxdrType {
    public byte[] code = null;
    public Unsigned8 blockControl = null;
    public Unsigned16 blockNumber = null;
    public Unsigned16 blockNumberAck = null;
    public AxdrOctetString blockData = null;

    public GeneralBlockTransfer() {
    }

    public GeneralBlockTransfer(byte[] code) {
        this.code = code;
    }

    public GeneralBlockTransfer(Unsigned8 blockControl, Unsigned16 blockNumber, Unsigned16 blockNumberAck, AxdrOctetString blockData) {
        this.blockControl = blockControl;
        this.blockNumber = blockNumber;
        this.blockNumberAck = blockNumberAck;
        this.blockData = blockData;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.blockData.encode(axdrOStream);
            codeLength += this.blockNumberAck.encode(axdrOStream);
            codeLength += this.blockNumber.encode(axdrOStream);
            codeLength += this.blockControl.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.blockControl = new Unsigned8();
        codeLength += this.blockControl.decode(iStream);
        this.blockNumber = new Unsigned16();
        codeLength += this.blockNumber.decode(iStream);
        this.blockNumberAck = new Unsigned16();
        codeLength += this.blockNumberAck.decode(iStream);
        this.blockData = new AxdrOctetString();
        return codeLength += this.blockData.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {blockControl: " + this.blockControl + ", blockNumber: " + this.blockNumber + ", blockNumberAck: " + this.blockNumberAck + ", blockData: " + this.blockData + "}";
    }
}

