/*
 * Decompiled with CFR 0.152.
 */
package org.openmuc.jdlms.internal.asn1.cosem;

import com.beanit.asn1bean.ber.ReverseByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import org.openmuc.jdlms.internal.asn1.axdr.AxdrType;
import org.openmuc.jdlms.internal.asn1.cosem.Enum;

public class ExceptionResponse
implements AxdrType {
    public byte[] code = null;
    public Enum stateError = null;
    public Enum serviceError = null;

    public ExceptionResponse() {
    }

    public ExceptionResponse(byte[] code) {
        this.code = code;
    }

    public ExceptionResponse(Enum stateError, Enum serviceError) {
        this.stateError = stateError;
        this.serviceError = serviceError;
    }

    @Override
    public int encode(ReverseByteArrayOutputStream axdrOStream) throws IOException {
        int codeLength;
        if (this.code != null) {
            codeLength = this.code.length;
            for (int i = this.code.length - 1; i >= 0; --i) {
                axdrOStream.write(this.code[i]);
            }
        } else {
            codeLength = 0;
            codeLength += this.serviceError.encode(axdrOStream);
            codeLength += this.stateError.encode(axdrOStream);
        }
        return codeLength;
    }

    @Override
    public int decode(InputStream iStream) throws IOException {
        int codeLength = 0;
        this.stateError = new Enum();
        codeLength += this.stateError.decode(iStream);
        this.serviceError = new Enum();
        return codeLength += this.serviceError.decode(iStream);
    }

    public void encodeAndSave(int encodingSizeGuess) throws IOException {
        ReverseByteArrayOutputStream axdrOStream = new ReverseByteArrayOutputStream(encodingSizeGuess);
        this.encode(axdrOStream);
        this.code = axdrOStream.getArray();
    }

    public String toString() {
        return "sequence: {stateError: " + this.stateError + ", serviceError: " + this.serviceError + "}";
    }
}

